/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gson.autoconfigure;

import com.google.gson.Gson;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.gson.autoconfigure.GsonAutoConfiguration;
import org.springframework.boot.test.autoconfigure.json.ConditionalOnJsonTesters;
import org.springframework.boot.test.autoconfigure.json.JsonMarshalTesterRuntimeHints;
import org.springframework.boot.test.autoconfigure.json.JsonTesterFactoryBean;
import org.springframework.boot.test.json.GsonTester;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ImportRuntimeHints;
import org.springframework.context.annotation.Scope;

@AutoConfiguration(after={GsonAutoConfiguration.class})
@ConditionalOnJsonTesters
final class GsonTesterTestAutoConfiguration {
    GsonTesterTestAutoConfiguration() {
    }

    @Bean
    @Scope(value="prototype")
    @ConditionalOnBean(value={Gson.class})
    @ImportRuntimeHints(value={GsonTesterRuntimeHints.class})
    FactoryBean<GsonTester<?>> gsonTesterFactoryBean(Gson gson) {
        return new JsonTesterFactoryBean(GsonTester.class, (Object)gson);
    }

    static class GsonTesterRuntimeHints
    extends JsonMarshalTesterRuntimeHints {
        GsonTesterRuntimeHints() {
            super(GsonTester.class);
        }
    }
}

