/*
 * Copyright 2012-present the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.boot.graphql.autoconfigure;

import org.springframework.graphql.execution.GraphQlSource;

/**
 * Callback interface that can be implemented by beans wishing to customize properties of
 * {@link org.springframework.graphql.execution.GraphQlSource.SchemaResourceBuilder
 * Builder} to fine-tune its auto-configuration.
 *
 * @author Rossen Stoyanchev
 * @since 4.0.0
 */
@FunctionalInterface
public interface GraphQlSourceBuilderCustomizer {

	/**
	 * Customize the
	 * {@link org.springframework.graphql.execution.GraphQlSource.SchemaResourceBuilder
	 * Builder} instance.
	 * @param builder builder the builder to customize
	 */
	void customize(GraphQlSource.SchemaResourceBuilder builder);

}
