/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.graphql.test.autoconfigure.tester;

import org.jspecify.annotations.Nullable;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.graphql.autoconfigure.GraphQlProperties;
import org.springframework.boot.test.http.server.LocalTestWebServer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.graphql.test.tester.HttpGraphQlTester;
import org.springframework.graphql.test.tester.WebGraphQlTester;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.web.reactive.function.client.WebClient;

@AutoConfiguration(afterName={"org.springframework.boot.webtestclient.WebTestClientAutoConfiguration"})
@ConditionalOnClass(value={WebClient.class, WebTestClient.class, WebGraphQlTester.class})
@EnableConfigurationProperties(value={GraphQlProperties.class})
public final class HttpGraphQlTesterAutoConfiguration {
    @Bean
    @ConditionalOnBean(value={WebTestClient.class})
    @ConditionalOnMissingBean
    HttpGraphQlTester webTestClientGraphQlTester(ApplicationContext applicationContext, WebTestClient webTestClient, GraphQlProperties properties) {
        String graphQlPath = properties.getHttp().getPath();
        LocalTestWebServer localTestWebServer = LocalTestWebServer.get((ApplicationContext)applicationContext);
        return HttpGraphQlTester.create((WebTestClient)this.createWebTestClient(webTestClient.mutate(), localTestWebServer, graphQlPath));
    }

    private WebTestClient createWebTestClient(WebTestClient.Builder builder, @Nullable LocalTestWebServer localTestWebServer, String graphQlPath) {
        return localTestWebServer != null ? builder.uriBuilderFactory(localTestWebServer.withPath(graphQlPath).uriBuilderFactory()).build() : builder.baseUrl(graphQlPath).build();
    }
}

