/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.tasks.bundling;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.gradle.api.Project;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.springframework.boot.loader.tools.FileUtils;

public class LaunchScriptConfiguration
implements Serializable {
    private static final Pattern WHITE_SPACE_PATTERN = Pattern.compile("\\s+");
    private static final Pattern LINE_FEED_PATTERN = Pattern.compile("\n");
    private final Map<String, String> properties = new HashMap<String, String>();
    private File script;

    public LaunchScriptConfiguration() {
    }

    LaunchScriptConfiguration(AbstractArchiveTask archiveTask) {
        Project project = archiveTask.getProject();
        String baseName = (String)archiveTask.getArchiveBaseName().get();
        this.putIfMissing(this.properties, "initInfoProvides", baseName);
        this.putIfMissing(this.properties, "initInfoShortDescription", this.removeLineBreaks(project.getDescription()), baseName);
        this.putIfMissing(this.properties, "initInfoDescription", this.augmentLineBreaks(project.getDescription()), baseName);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void properties(Map<String, String> properties) {
        this.properties.putAll(properties);
    }

    public File getScript() {
        return this.script;
    }

    public void setScript(File script) {
        this.script = script;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LaunchScriptConfiguration other = (LaunchScriptConfiguration)obj;
        if (!this.properties.equals(other.properties)) {
            return false;
        }
        if (this.script == null) {
            return other.script == null;
        }
        if (!this.script.equals(other.script)) {
            return false;
        }
        return this.equalContents(this.script, other.script);
    }

    private boolean equalContents(File one, File two) {
        try {
            return FileUtils.sha1Hash((File)one).equals(FileUtils.sha1Hash((File)two));
        }
        catch (IOException ex) {
            return false;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.properties.hashCode();
        result = 31 * result + (this.script == null ? 0 : this.script.hashCode());
        return result;
    }

    private String removeLineBreaks(String string) {
        return string != null ? WHITE_SPACE_PATTERN.matcher(string).replaceAll(" ") : null;
    }

    private String augmentLineBreaks(String string) {
        return string != null ? LINE_FEED_PATTERN.matcher(string).replaceAll("\n#  ") : null;
    }

    private void putIfMissing(Map<String, String> properties, String key, String ... valueCandidates) {
        if (!properties.containsKey(key)) {
            for (String candidate : valueCandidates) {
                if (candidate == null || candidate.isEmpty()) continue;
                properties.put(key, candidate);
                return;
            }
        }
    }
}

