/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.tasks.buildinfo;

import java.io.Serializable;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.Project;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;

public class BuildInfoProperties
implements Serializable {
    private final Property<String> group;
    private final Property<String> artifact;
    private final Property<String> version;
    private final Property<String> name;
    private final Property<Instant> time;
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    BuildInfoProperties(Project project) {
        this.time = project.getObjects().property(Instant.class);
        this.time.set((Object)Instant.now());
        this.group = project.getObjects().property(String.class);
        this.group.set(project.provider(() -> project.getGroup().toString()));
        this.artifact = project.getObjects().property(String.class);
        this.version = project.getObjects().property(String.class);
        this.version.set(project.provider(() -> project.getVersion().toString()));
        this.name = project.getObjects().property(String.class);
        this.name.set(project.provider(() -> project.getName()));
    }

    @Input
    @Optional
    public String getGroup() {
        return (String)this.group.getOrNull();
    }

    public void setGroup(String group) {
        this.group.set((Object)group);
    }

    @Input
    @Optional
    public String getArtifact() {
        return (String)this.artifact.getOrNull();
    }

    public void setArtifact(String artifact) {
        this.artifact.set((Object)artifact);
    }

    @Input
    @Optional
    public String getVersion() {
        return (String)this.version.getOrNull();
    }

    public void setVersion(String version) {
        this.version.set((Object)version);
    }

    @Input
    @Optional
    public String getName() {
        return (String)this.name.getOrNull();
    }

    public void setName(String name) {
        this.name.set((Object)name);
    }

    @Input
    @Optional
    public Instant getTime() {
        return (Instant)this.time.getOrNull();
    }

    public void setTime(Instant time) {
        this.time.set((Object)time);
    }

    @Input
    @Optional
    public Map<String, Object> getAdditional() {
        return this.additionalProperties;
    }

    public void setAdditional(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }
}

