/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.repackage;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarFile;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.bundling.Jar;
import org.springframework.boot.gradle.SpringBootPluginExtension;
import org.springframework.boot.gradle.repackage.ProjectLibraries;
import org.springframework.boot.loader.tools.DefaultLaunchScript;
import org.springframework.boot.loader.tools.LaunchScript;
import org.springframework.boot.loader.tools.Repackager;
import org.springframework.util.FileCopyUtils;

public class RepackageTask
extends DefaultTask {
    private static final long FIND_WARNING_TIMEOUT = TimeUnit.SECONDS.toMillis(10L);
    private String customConfiguration;
    private Object withJarTask;
    private String mainClass;
    private String classifier;
    private File outputFile;
    private Boolean excludeDevtools;
    private Boolean executable;
    private File embeddedLaunchScript;
    private Map<String, String> embeddedLaunchScriptProperties;

    public void setCustomConfiguration(String customConfiguration) {
        this.customConfiguration = customConfiguration;
    }

    public Object getWithJarTask() {
        return this.withJarTask;
    }

    public void setWithJarTask(Object withJarTask) {
        this.withJarTask = withJarTask;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    void setOutputFile(File file) {
        this.outputFile = file;
    }

    public Boolean getExcludeDevtools() {
        return this.excludeDevtools;
    }

    public void setExcludeDevtools(Boolean excludeDevtools) {
        this.excludeDevtools = excludeDevtools;
    }

    public Boolean getExecutable() {
        return this.executable;
    }

    public void setExecutable(Boolean executable) {
        this.executable = executable;
    }

    public File getEmbeddedLaunchScript() {
        return this.embeddedLaunchScript;
    }

    public void setEmbeddedLaunchScript(File embeddedLaunchScript) {
        this.embeddedLaunchScript = embeddedLaunchScript;
    }

    public Map<String, String> getEmbeddedLaunchScriptProperties() {
        return this.embeddedLaunchScriptProperties;
    }

    public void setEmbeddedLaunchScriptProperties(Map<String, String> embeddedLaunchScriptProperties) {
        this.embeddedLaunchScriptProperties = embeddedLaunchScriptProperties;
    }

    @TaskAction
    public void repackage() {
        Project project = this.getProject();
        SpringBootPluginExtension extension = (SpringBootPluginExtension)project.getExtensions().getByType(SpringBootPluginExtension.class);
        ProjectLibraries libraries = this.getLibraries();
        project.getTasks().withType(Jar.class, (Action)new RepackageAction(extension, libraries));
    }

    public ProjectLibraries getLibraries() {
        Project project = this.getProject();
        SpringBootPluginExtension extension = (SpringBootPluginExtension)project.getExtensions().getByType(SpringBootPluginExtension.class);
        ProjectLibraries libraries = new ProjectLibraries(project, extension, this.excludeDevtools != null && this.excludeDevtools != false || extension.isExcludeDevtools());
        if (extension.getProvidedConfiguration() != null) {
            libraries.setProvidedConfigurationName(extension.getProvidedConfiguration());
        }
        if (this.customConfiguration != null) {
            libraries.setCustomConfigurationName(this.customConfiguration);
        } else if (extension.getCustomConfiguration() != null) {
            libraries.setCustomConfigurationName(extension.getCustomConfiguration());
        }
        return libraries;
    }

    private class LoggingRepackager
    extends Repackager {
        LoggingRepackager(File source) {
            super(source);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected String findMainMethod(JarFile source) throws IOException {
            long startTime = System.currentTimeMillis();
            try {
                String string = super.findMainMethod(source);
                return string;
            }
            finally {
                long duration = System.currentTimeMillis() - startTime;
                if (duration > FIND_WARNING_TIMEOUT) {
                    RepackageTask.this.getLogger().warn("Searching for the main-class is taking some time, consider using setting 'springBoot.mainClass'");
                }
            }
        }
    }

    private class RepackageAction
    implements Action<Jar> {
        private final SpringBootPluginExtension extension;
        private final ProjectLibraries libraries;

        RepackageAction(SpringBootPluginExtension extension, ProjectLibraries libraries) {
            this.extension = extension;
            this.libraries = libraries;
        }

        public void execute(Jar jarTask) {
            if (!RepackageTask.this.isEnabled()) {
                RepackageTask.this.getLogger().info("Repackage disabled");
                return;
            }
            Object withJarTask = RepackageTask.this.withJarTask;
            if (!this.isTaskMatch(jarTask, withJarTask)) {
                RepackageTask.this.getLogger().info("Jar task not repackaged (didn't match withJarTask): " + jarTask);
                return;
            }
            File file = jarTask.getArchivePath();
            if (file.exists()) {
                this.repackage(file);
            }
        }

        private boolean isTaskMatch(Jar task, Object withJarTask) {
            if (withJarTask == null) {
                if ("".equals(task.getClassifier())) {
                    HashSet<Object> tasksWithCustomRepackaging = new HashSet<Object>();
                    for (RepackageTask repackageTask : RepackageTask.this.getProject().getTasks().withType(RepackageTask.class)) {
                        if (repackageTask.getWithJarTask() == null) continue;
                        tasksWithCustomRepackaging.add(repackageTask.getWithJarTask());
                    }
                    return !tasksWithCustomRepackaging.contains(task);
                }
                return false;
            }
            return task.equals(withJarTask) || task.getName().equals(withJarTask);
        }

        private void repackage(File file) {
            File outputFile = RepackageTask.this.outputFile;
            if (outputFile != null && !file.equals(outputFile)) {
                this.copy(file, outputFile);
                file = outputFile;
            }
            LoggingRepackager repackager = new LoggingRepackager(file);
            this.setMainClass(repackager);
            if (this.extension.convertLayout() != null) {
                repackager.setLayout(this.extension.convertLayout());
            }
            repackager.setBackupSource(this.extension.isBackupSource());
            try {
                LaunchScript launchScript = this.getLaunchScript();
                repackager.repackage(file, this.libraries, launchScript);
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex.getMessage(), ex);
            }
        }

        private void copy(File source, File dest) {
            try {
                FileCopyUtils.copy((File)source, (File)dest);
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex.getMessage(), ex);
            }
        }

        private void setMainClass(Repackager repackager) {
            String mainClass = null;
            if (RepackageTask.this.getProject().hasProperty("mainClassName")) {
                mainClass = (String)RepackageTask.this.getProject().property("mainClassName");
            } else {
                ExtraPropertiesExtension extraProperties = (ExtraPropertiesExtension)RepackageTask.this.getProject().getExtensions().getByName("ext");
                if (extraProperties.has("mainClassName")) {
                    mainClass = (String)extraProperties.get("mainClassName");
                }
            }
            if (RepackageTask.this.mainClass != null) {
                mainClass = RepackageTask.this.mainClass;
            } else if (this.extension.getMainClass() != null) {
                mainClass = this.extension.getMainClass();
            } else {
                Task runTask = (Task)RepackageTask.this.getProject().getTasks().findByName("run");
                if (runTask != null && runTask.hasProperty("main")) {
                    mainClass = (String)RepackageTask.this.getProject().getTasks().getByName("run").property("main");
                }
            }
            if (mainClass != null) {
                RepackageTask.this.getLogger().info("Setting mainClass: " + mainClass);
                repackager.setMainClass(mainClass);
            } else {
                RepackageTask.this.getLogger().info("No mainClass configured");
            }
        }

        private LaunchScript getLaunchScript() throws IOException {
            if (this.isExecutable() || this.getEmbeddedLaunchScript() != null) {
                return new DefaultLaunchScript(this.getEmbeddedLaunchScript(), this.getEmbeddedLaunchScriptProperties());
            }
            return null;
        }

        private boolean isExecutable() {
            return RepackageTask.this.executable != null ? RepackageTask.this.executable.booleanValue() : this.extension.isExecutable();
        }

        private File getEmbeddedLaunchScript() {
            return RepackageTask.this.embeddedLaunchScript != null ? RepackageTask.this.embeddedLaunchScript : this.extension.getEmbeddedLaunchScript();
        }

        private Map<String, String> getEmbeddedLaunchScriptProperties() {
            return RepackageTask.this.embeddedLaunchScriptProperties != null ? RepackageTask.this.embeddedLaunchScriptProperties : this.extension.getEmbeddedLaunchScriptProperties();
        }
    }
}

