/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.resolve;

import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencyResolveDetails;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.springframework.boot.dependency.tools.Dependency;
import org.springframework.boot.dependency.tools.ManagedDependencies;
import org.springframework.boot.gradle.VersionManagedDependencies;

public class SpringBootResolutionStrategy {
    private static final String SPRING_BOOT_GROUP = "org.springframework.boot";

    public static void applyToConfiguration(Project project, Configuration configuration) {
        if ("versionManagement".equals(configuration.getName())) {
            return;
        }
        VersionResolver versionResolver = new VersionResolver(project);
        configuration.getResolutionStrategy().eachDependency((Action)versionResolver);
    }

    private static class VersionResolver
    implements Action<DependencyResolveDetails> {
        private final VersionManagedDependencies versionManagedDependencies;

        public VersionResolver(Project project) {
            this.versionManagedDependencies = new VersionManagedDependencies(project);
        }

        public void execute(DependencyResolveDetails resolveDetails) {
            String version = resolveDetails.getTarget().getVersion();
            if (version == null || version.trim().length() == 0) {
                this.resolve(resolveDetails);
            }
        }

        private void resolve(DependencyResolveDetails resolveDetails) {
            ManagedDependencies dependencies = this.versionManagedDependencies.getManagedDependencies();
            ModuleVersionSelector target = resolveDetails.getTarget();
            if (SpringBootResolutionStrategy.SPRING_BOOT_GROUP.equals(target.getGroup())) {
                resolveDetails.useVersion(dependencies.getSpringBootVersion());
                return;
            }
            Dependency dependency = dependencies.find(target.getGroup(), target.getName());
            if (dependency != null) {
                resolveDetails.useVersion(dependency.getVersion());
            }
        }
    }
}

