/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.flyway.autoconfigure;

import java.lang.invoke.LambdaMetafactory;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.springframework.boot.jdbc.SchemaManagement;
import org.springframework.boot.jdbc.SchemaManagementProvider;

class FlywaySchemaManagementProvider
implements SchemaManagementProvider {
    private final Iterable<Flyway> flywayInstances;

    FlywaySchemaManagementProvider(Iterable<Flyway> flywayInstances) {
        this.flywayInstances = flywayInstances;
    }

    public SchemaManagement getSchemaManagement(DataSource dataSource) {
        return StreamSupport.stream(this.flywayInstances.spliterator(), false).map(flyway -> flyway.getConfiguration().getDataSource()).filter((Predicate<DataSource>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Ljavax/sql/DataSource;)Z)((DataSource)dataSource)).findFirst().map(managedDataSource -> SchemaManagement.MANAGED).orElse(SchemaManagement.UNMANAGED);
    }
}

