/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.flyway.autoconfigure;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.Location;
import org.flywaydb.core.api.ResourceProvider;
import org.flywaydb.core.api.resource.LoadableResource;
import org.flywaydb.core.internal.resource.classpath.ClassPathResource;
import org.flywaydb.core.internal.scanner.Scanner;
import org.flywaydb.core.internal.util.StringUtils;
import org.jspecify.annotations.Nullable;
import org.springframework.core.NativeDetector;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

class NativeImageResourceProvider
implements ResourceProvider {
    private final Scanner<?> scanner;
    private final ClassLoader classLoader;
    private final Collection<Location> locations;
    private final Charset encoding;
    private final boolean failOnMissingLocations;
    private final List<LocatedResource> locatedResources = new ArrayList<LocatedResource>();
    private final Lock lock = new ReentrantLock();
    private boolean initialized;

    NativeImageResourceProvider(Scanner<?> scanner, ClassLoader classLoader, Collection<Location> locations, Charset encoding, boolean failOnMissingLocations) {
        this.scanner = scanner;
        this.classLoader = classLoader;
        this.locations = locations;
        this.encoding = encoding;
        this.failOnMissingLocations = failOnMissingLocations;
    }

    public @Nullable LoadableResource getResource(String name) {
        if (!NativeDetector.inNativeImage()) {
            return this.scanner.getResource(name);
        }
        LoadableResource resource = this.scanner.getResource(name);
        if (resource != null) {
            return resource;
        }
        if (this.classLoader.getResource(name) == null) {
            return null;
        }
        return new ClassPathResource(null, name, this.classLoader, this.encoding);
    }

    public Collection<LoadableResource> getResources(String prefix, String[] suffixes) {
        if (!NativeDetector.inNativeImage()) {
            return this.scanner.getResources(prefix, suffixes);
        }
        this.ensureInitialized();
        Predicate<LocatedResource> matchesPrefixAndSuffixes = locatedResource -> StringUtils.startsAndEndsWith((String)locatedResource.resource.getFilename(), (String)prefix, (String[])suffixes);
        ArrayList<LoadableResource> result = new ArrayList<LoadableResource>(this.scanner.getResources(prefix, suffixes));
        this.locatedResources.stream().filter(matchesPrefixAndSuffixes).map(this::asClassPathResource).forEach(result::add);
        return result;
    }

    private ClassPathResource asClassPathResource(LocatedResource locatedResource) {
        Location location = locatedResource.location();
        String fileNameWithAbsolutePath = location.getPath() + "/" + locatedResource.resource().getFilename();
        return new ClassPathResource(location, fileNameWithAbsolutePath, this.classLoader, this.encoding);
    }

    private void ensureInitialized() {
        this.lock.lock();
        try {
            if (!this.initialized) {
                this.initialize();
                this.initialized = true;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void initialize() {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        for (Location location : this.locations) {
            Resource[] resources;
            if (!location.isClassPath()) continue;
            Resource root = resolver.getResource(location.getDescriptor());
            if (!root.exists()) {
                if (!this.failOnMissingLocations) continue;
                throw new FlywayException("Location " + location.getDescriptor() + " doesn't exist");
            }
            for (Resource resource : resources = this.getResources(resolver, location, root)) {
                this.locatedResources.add(new LocatedResource(resource, location));
            }
        }
    }

    private Resource[] getResources(PathMatchingResourcePatternResolver resolver, Location location, Resource root) {
        try {
            return resolver.getResources(String.valueOf(root.getURI()) + "/*");
        }
        catch (IOException ex) {
            throw new UncheckedIOException("Failed to list resources for " + location.getDescriptor(), ex);
        }
    }

    private record LocatedResource(Resource resource, Location location) {
    }
}

