/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.elasticsearch.autoconfigure;

import co.elastic.clients.transport.rest5_client.low_level.Rest5Client;
import co.elastic.clients.transport.rest5_client.low_level.Rest5ClientBuilder;
import co.elastic.clients.transport.rest5_client.low_level.sniffer.Sniffer;
import co.elastic.clients.transport.rest5_client.low_level.sniffer.SnifferBuilder;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.stream.Stream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.async.HttpAsyncClientBuilder;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.reactor.ssl.SSLBufferMode;
import org.apache.hc.core5.util.Timeout;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.elasticsearch.autoconfigure.ElasticsearchConnectionDetails;
import org.springframework.boot.elasticsearch.autoconfigure.ElasticsearchProperties;
import org.springframework.boot.elasticsearch.autoconfigure.Rest5ClientBuilderCustomizer;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.boot.ssl.SslOptions;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class ElasticsearchRestClientConfigurations {
    ElasticsearchRestClientConfigurations() {
    }

    static class PropertiesElasticsearchConnectionDetails
    implements ElasticsearchConnectionDetails {
        private final ElasticsearchProperties properties;
        private final @Nullable SslBundles sslBundles;

        PropertiesElasticsearchConnectionDetails(ElasticsearchProperties properties, @Nullable SslBundles sslBundles) {
            this.properties = properties;
            this.sslBundles = sslBundles;
        }

        @Override
        public List<ElasticsearchConnectionDetails.Node> getNodes() {
            return this.properties.getUris().stream().map(this::createNode).toList();
        }

        @Override
        public @Nullable String getUsername() {
            return this.properties.getUsername();
        }

        @Override
        public @Nullable String getPassword() {
            return this.properties.getPassword();
        }

        @Override
        public @Nullable String getApiKey() {
            return this.properties.getApiKey();
        }

        @Override
        public @Nullable String getPathPrefix() {
            return this.properties.getPathPrefix();
        }

        @Override
        public @Nullable SslBundle getSslBundle() {
            ElasticsearchProperties.Restclient.Ssl ssl = this.properties.getRestclient().getSsl();
            if (StringUtils.hasLength((String)ssl.getBundle())) {
                Assert.notNull((Object)this.sslBundles, (String)"SSL bundle name has been set but no SSL bundles found in context");
                return this.sslBundles.getBundle(ssl.getBundle());
            }
            return null;
        }

        private ElasticsearchConnectionDetails.Node createNode(String uri) {
            if (!((String)uri).startsWith("http://") && !((String)uri).startsWith("https://")) {
                uri = "http://" + (String)uri;
            }
            return this.createNode(URI.create((String)uri));
        }

        private ElasticsearchConnectionDetails.Node createNode(URI uri) {
            String userInfo = uri.getUserInfo();
            ElasticsearchConnectionDetails.Node.Protocol protocol = ElasticsearchConnectionDetails.Node.Protocol.forScheme(uri.getScheme());
            if (!StringUtils.hasLength((String)userInfo)) {
                return new ElasticsearchConnectionDetails.Node(uri.getHost(), uri.getPort(), protocol, null, null);
            }
            int separatorIndex = userInfo.indexOf(58);
            if (separatorIndex == -1) {
                return new ElasticsearchConnectionDetails.Node(uri.getHost(), uri.getPort(), protocol, userInfo, null);
            }
            String[] components = userInfo.split(":");
            return new ElasticsearchConnectionDetails.Node(uri.getHost(), uri.getPort(), protocol, components[0], components.length > 1 ? components[1] : "");
        }
    }

    private static class ConnectionDetailsCredentialsProvider
    extends BasicCredentialsProvider {
        ConnectionDetailsCredentialsProvider(ElasticsearchConnectionDetails connectionDetails) {
            String username = connectionDetails.getUsername();
            if (StringUtils.hasText((String)username)) {
                String password = connectionDetails.getPassword();
                char[] passwordChars = StringUtils.hasText((String)password) ? password.toCharArray() : null;
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(username, passwordChars);
                this.setCredentials(new AuthScope(null, -1), (Credentials)credentials);
            }
            Stream<URI> uris = this.getUris(connectionDetails);
            uris.filter(this::hasUserInfo).forEach(this::addUserInfoCredentials);
        }

        private Stream<URI> getUris(ElasticsearchConnectionDetails connectionDetails) {
            return connectionDetails.getNodes().stream().map(ElasticsearchConnectionDetails.Node::toUri);
        }

        private boolean hasUserInfo(@Nullable URI uri) {
            return uri != null && StringUtils.hasLength((String)uri.getUserInfo());
        }

        private void addUserInfoCredentials(URI uri) {
            AuthScope authScope = new AuthScope(uri.getHost(), uri.getPort());
            Credentials credentials = this.createUserInfoCredentials(uri.getUserInfo());
            this.setCredentials(authScope, credentials);
        }

        private Credentials createUserInfoCredentials(String userInfo) {
            int delimiter = userInfo.indexOf(":");
            if (delimiter == -1) {
                return new UsernamePasswordCredentials(userInfo, null);
            }
            String username = userInfo.substring(0, delimiter);
            String password = userInfo.substring(delimiter + 1);
            return new UsernamePasswordCredentials(username, password.toCharArray());
        }
    }

    static class DefaultRest5ClientBuilderCustomizer
    implements Rest5ClientBuilderCustomizer,
    Ordered {
        private final ElasticsearchProperties properties;
        private final ElasticsearchConnectionDetails connectionDetails;

        DefaultRest5ClientBuilderCustomizer(ElasticsearchProperties properties, ElasticsearchConnectionDetails connectionDetails) {
            this.properties = properties;
            this.connectionDetails = connectionDetails;
        }

        @Override
        public void customize(Rest5ClientBuilder restClientBuilder) {
        }

        @Override
        public void customize(HttpAsyncClientBuilder httpClientBuilder) {
            httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)new ConnectionDetailsCredentialsProvider(this.connectionDetails));
            PropertyMapper map = PropertyMapper.get();
            map.from(this.properties::isSocketKeepAlive).to(keepAlive -> httpClientBuilder.setIOReactorConfig(IOReactorConfig.custom().setSoKeepAlive(keepAlive.booleanValue()).build()));
        }

        @Override
        public void customize(ConnectionConfig.Builder connectionConfigBuilder) {
            PropertyMapper map = PropertyMapper.get();
            map.from(this.properties::getConnectionTimeout).as(Timeout::of).to(arg_0 -> ((ConnectionConfig.Builder)connectionConfigBuilder).setConnectTimeout(arg_0));
            map.from(this.properties::getSocketTimeout).as(Timeout::of).to(arg_0 -> ((ConnectionConfig.Builder)connectionConfigBuilder).setSocketTimeout(arg_0));
        }

        @Override
        public void customize(PoolingAsyncClientConnectionManagerBuilder connectionManagerBuilder) {
            SslBundle sslBundle = this.connectionDetails.getSslBundle();
            if (sslBundle != null) {
                SSLContext sslContext = sslBundle.createSslContext();
                SslOptions sslOptions = sslBundle.getOptions();
                DefaultClientTlsStrategy tlsStrategy = new DefaultClientTlsStrategy(sslContext, sslOptions.getEnabledProtocols(), sslOptions.getCiphers(), SSLBufferMode.STATIC, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                connectionManagerBuilder.setTlsStrategy((TlsStrategy)tlsStrategy);
            }
        }

        public int getOrder() {
            return 0;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Sniffer.class})
    @ConditionalOnSingleCandidate(value=Rest5Client.class)
    @ConditionalOnProperty(name={"spring.elasticsearch.restclient.sniffer.enabled"}, matchIfMissing=true)
    static class RestClientSnifferConfiguration {
        RestClientSnifferConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        Sniffer elasticsearchSniffer(Rest5Client client, ElasticsearchProperties properties) {
            SnifferBuilder builder = Sniffer.builder((Rest5Client)client);
            PropertyMapper map = PropertyMapper.get();
            Duration interval = properties.getRestclient().getSniffer().getInterval();
            map.from((Object)interval).asInt(Duration::toMillis).to(arg_0 -> ((SnifferBuilder)builder).setSniffIntervalMillis(arg_0));
            Duration delayAfterFailure = properties.getRestclient().getSniffer().getDelayAfterFailure();
            map.from((Object)delayAfterFailure).asInt(Duration::toMillis).to(arg_0 -> ((SnifferBuilder)builder).setSniffAfterFailureDelayMillis(arg_0));
            return builder.build();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={Rest5Client.class})
    static class RestClientConfiguration {
        RestClientConfiguration() {
        }

        @Bean
        Rest5Client elasticsearchRestClient(Rest5ClientBuilder restClientBuilder) {
            return restClientBuilder.build();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={Rest5ClientBuilder.class})
    static class RestClientBuilderConfiguration {
        private final ElasticsearchProperties properties;

        RestClientBuilderConfiguration(ElasticsearchProperties properties) {
            this.properties = properties;
        }

        @Bean
        @ConditionalOnMissingBean(value={ElasticsearchConnectionDetails.class})
        PropertiesElasticsearchConnectionDetails elasticsearchConnectionDetails(ObjectProvider<SslBundles> sslBundles) {
            return new PropertiesElasticsearchConnectionDetails(this.properties, (SslBundles)sslBundles.getIfAvailable());
        }

        @Bean
        Rest5ClientBuilderCustomizer defaultRestClientBuilderCustomizer(ElasticsearchConnectionDetails connectionDetails) {
            return new DefaultRest5ClientBuilderCustomizer(this.properties, connectionDetails);
        }

        @Bean
        Rest5ClientBuilder elasticsearchRestClientBuilder(ElasticsearchConnectionDetails connectionDetails, ObjectProvider<Rest5ClientBuilderCustomizer> builderCustomizers) {
            Rest5ClientBuilder builder = Rest5Client.builder((HttpHost[])((HttpHost[])connectionDetails.getNodes().stream().map(node -> new HttpHost(node.protocol().getScheme(), node.hostname(), node.port())).toArray(HttpHost[]::new)));
            if (connectionDetails.getApiKey() != null) {
                builder.setDefaultHeaders(new Header[]{new BasicHeader("Authorization", (Object)("ApiKey " + connectionDetails.getApiKey()))});
            }
            builder.setHttpClientConfigCallback(httpClientBuilder -> builderCustomizers.orderedStream().forEach(customizer -> customizer.customize((HttpAsyncClientBuilder)httpClientBuilder)));
            builder.setConnectionManagerCallback(connectionManagerBuilder -> builderCustomizers.orderedStream().forEach(customizer -> customizer.customize((PoolingAsyncClientConnectionManagerBuilder)connectionManagerBuilder)));
            builder.setConnectionConfigCallback(connectionConfigBuilder -> builderCustomizers.orderedStream().forEach(customizer -> customizer.customize((ConnectionConfig.Builder)connectionConfigBuilder)));
            builder.setRequestConfigCallback(requestConfigBuilder -> builderCustomizers.orderedStream().forEach(customizer -> customizer.customize((RequestConfig.Builder)requestConfigBuilder)));
            String pathPrefix = connectionDetails.getPathPrefix();
            if (pathPrefix != null) {
                builder.setPathPrefix(pathPrefix);
            }
            builderCustomizers.orderedStream().forEach(customizer -> customizer.customize(builder));
            return builder;
        }
    }
}

