/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.elasticsearch.autoconfigure;

import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.rest5_client.low_level.Rest5Client;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.elasticsearch.autoconfigure.ElasticsearchClientAutoConfiguration;
import org.springframework.boot.elasticsearch.autoconfigure.ElasticsearchClientConfigurations;
import org.springframework.boot.elasticsearch.autoconfigure.ElasticsearchProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.data.elasticsearch.client.elc.ReactiveElasticsearchClient;
import reactor.core.publisher.Mono;

@AutoConfiguration(after={ElasticsearchClientAutoConfiguration.class})
@ConditionalOnBean(value={Rest5Client.class})
@ConditionalOnClass(value={ReactiveElasticsearchClient.class, ElasticsearchTransport.class, Mono.class})
@EnableConfigurationProperties(value={ElasticsearchProperties.class})
@Import(value={ElasticsearchClientConfigurations.JsonpMapperConfiguration.class, ElasticsearchClientConfigurations.ElasticsearchTransportConfiguration.class})
public final class ElasticsearchReactiveClientAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={ElasticsearchTransport.class})
    ReactiveElasticsearchClient reactiveElasticsearchClient(ElasticsearchTransport transport) {
        return new ReactiveElasticsearchClient(transport);
    }
}

