/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.elasticsearch.autoconfigure.health;

import co.elastic.clients.transport.rest5_client.low_level.Rest5Client;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.elasticsearch.autoconfigure.ElasticsearchRestClientAutoConfiguration;
import org.springframework.boot.elasticsearch.health.ElasticsearchRestClientHealthIndicator;
import org.springframework.boot.health.autoconfigure.contributor.CompositeHealthContributorConfiguration;
import org.springframework.boot.health.autoconfigure.contributor.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.health.contributor.HealthContributor;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={ElasticsearchRestClientAutoConfiguration.class})
@ConditionalOnClass(value={Rest5Client.class, ConditionalOnEnabledHealthIndicator.class})
@ConditionalOnBean(value={Rest5Client.class})
@ConditionalOnEnabledHealthIndicator(value="elasticsearch")
public final class ElasticsearchRestHealthContributorAutoConfiguration
extends CompositeHealthContributorConfiguration<ElasticsearchRestClientHealthIndicator, Rest5Client> {
    ElasticsearchRestHealthContributorAutoConfiguration() {
        super(ElasticsearchRestClientHealthIndicator::new);
    }

    @Bean
    @ConditionalOnMissingBean(name={"elasticsearchHealthIndicator", "elasticsearchHealthContributor"})
    HealthContributor elasticsearchHealthContributor(ConfigurableListableBeanFactory beanFactory) {
        return (HealthContributor)this.createContributor(beanFactory, Rest5Client.class);
    }
}

