/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.docker.compose.core;

import java.net.URI;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.docker.compose.core.DockerCliContextResponse;
import org.springframework.util.StringUtils;

final class DockerHost {
    private static final String LOCALHOST = "127.0.0.1";
    private final String host;

    private DockerHost(String host) {
        this.host = host;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DockerHost other = (DockerHost)obj;
        return this.host.equals(other.host);
    }

    public int hashCode() {
        return this.host.hashCode();
    }

    public String toString() {
        return this.host;
    }

    static DockerHost get(@Nullable String host, Supplier<List<DockerCliContextResponse>> contextsSupplier) {
        return DockerHost.get(host, System::getenv, contextsSupplier);
    }

    static DockerHost get(@Nullable String host, Function<String, @Nullable String> systemEnv, Supplier<List<DockerCliContextResponse>> contextsSupplier) {
        host = StringUtils.hasText((String)host) ? host : DockerHost.fromServicesHostEnv(systemEnv);
        host = StringUtils.hasText((String)host) ? host : DockerHost.fromDockerHostEnv(systemEnv);
        host = StringUtils.hasText((String)host) ? host : DockerHost.fromCurrentContext(contextsSupplier);
        host = StringUtils.hasText((String)host) ? host : LOCALHOST;
        return new DockerHost(host);
    }

    private static @Nullable String fromServicesHostEnv(Function<String, @Nullable String> systemEnv) {
        return systemEnv.apply("SERVICES_HOST");
    }

    private static @Nullable String fromDockerHostEnv(Function<String, @Nullable String> systemEnv) {
        return DockerHost.fromEndpoint(systemEnv.apply("DOCKER_HOST"));
    }

    private static @Nullable String fromCurrentContext(Supplier<List<DockerCliContextResponse>> contextsSupplier) {
        DockerCliContextResponse current = DockerHost.getCurrentContext(contextsSupplier.get());
        return current != null ? DockerHost.fromEndpoint(current.dockerEndpoint()) : null;
    }

    private static @Nullable DockerCliContextResponse getCurrentContext(List<DockerCliContextResponse> candidates) {
        return candidates.stream().filter(DockerCliContextResponse::current).findFirst().orElse(null);
    }

    private static @Nullable String fromEndpoint(@Nullable String endpoint) {
        return StringUtils.hasLength((String)endpoint) ? DockerHost.fromUri(URI.create(endpoint)) : null;
    }

    private static @Nullable String fromUri(URI uri) {
        try {
            return switch (uri.getScheme()) {
                case "http", "https", "tcp" -> uri.getHost();
                default -> null;
            };
        }
        catch (Exception ex) {
            return null;
        }
    }
}

