/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.docker.compose.core;

import java.util.List;
import java.util.Locale;
import tools.jackson.databind.DeserializationFeature;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.MapperFeature;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.json.JsonMapper;
import tools.jackson.databind.type.CollectionType;

final class DockerJson {
    private static final ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().defaultLocale(Locale.ENGLISH)).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES})).disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES})).build();

    private DockerJson() {
    }

    static <T> List<T> deserializeToList(String json, Class<T> itemType) {
        if (json.startsWith("[")) {
            CollectionType javaType = objectMapper.getTypeFactory().constructCollectionType(List.class, itemType);
            return (List)DockerJson.deserialize(json, (JavaType)javaType);
        }
        return json.trim().lines().map(line -> DockerJson.deserialize(line, itemType)).toList();
    }

    static <T> T deserialize(String json, Class<T> type) {
        return DockerJson.deserialize(json, objectMapper.getTypeFactory().constructType(type));
    }

    private static <T> T deserialize(String json, JavaType type) {
        return (T)objectMapper.readValue(json.trim(), type);
    }
}

