/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.docker.compose.service.connection.neo4j;

import java.net.URI;
import org.neo4j.driver.AuthToken;
import org.springframework.boot.autoconfigure.neo4j.Neo4jConnectionDetails;
import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionDetailsFactory;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionSource;
import org.springframework.boot.docker.compose.service.connection.neo4j.Neo4jEnvironment;

class Neo4jDockerComposeConnectionDetailsFactory
extends DockerComposeConnectionDetailsFactory<Neo4jConnectionDetails> {
    private static final String[] NEO4J_CONTAINER_NAMES = new String[]{"neo4j", "bitnami/neo4j"};

    Neo4jDockerComposeConnectionDetailsFactory() {
        super(NEO4J_CONTAINER_NAMES, new String[0]);
    }

    @Override
    protected Neo4jConnectionDetails getDockerComposeConnectionDetails(DockerComposeConnectionSource source) {
        return new Neo4jDockerComposeConnectionDetails(source.getRunningService());
    }

    static class Neo4jDockerComposeConnectionDetails
    extends DockerComposeConnectionDetailsFactory.DockerComposeConnectionDetails
    implements Neo4jConnectionDetails {
        private static final int BOLT_PORT = 7687;
        private final AuthToken authToken;
        private final URI uri;

        Neo4jDockerComposeConnectionDetails(RunningService service) {
            super(service);
            Neo4jEnvironment neo4jEnvironment = new Neo4jEnvironment(service.env());
            this.authToken = neo4jEnvironment.getAuthToken();
            this.uri = URI.create("neo4j://%s:%d".formatted(service.host(), service.ports().get(7687)));
        }

        public URI getUri() {
            return this.uri;
        }

        public AuthToken getAuthToken() {
            return this.authToken;
        }
    }
}

