/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.docker.compose.service.connection.mysql;

import io.r2dbc.spi.ConnectionFactoryOptions;
import org.springframework.boot.autoconfigure.r2dbc.R2dbcConnectionDetails;
import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionDetailsFactory;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionSource;
import org.springframework.boot.docker.compose.service.connection.mysql.MySqlEnvironment;
import org.springframework.boot.docker.compose.service.connection.r2dbc.ConnectionFactoryOptionsBuilder;

class MySqlR2dbcDockerComposeConnectionDetailsFactory
extends DockerComposeConnectionDetailsFactory<R2dbcConnectionDetails> {
    private static final String[] MYSQL_CONTAINER_NAMES = new String[]{"mysql", "bitnami/mysql"};

    MySqlR2dbcDockerComposeConnectionDetailsFactory() {
        super(MYSQL_CONTAINER_NAMES, "io.r2dbc.spi.ConnectionFactoryOptions");
    }

    @Override
    protected R2dbcConnectionDetails getDockerComposeConnectionDetails(DockerComposeConnectionSource source) {
        return new MySqlR2dbcDockerComposeConnectionDetails(source.getRunningService());
    }

    static class MySqlR2dbcDockerComposeConnectionDetails
    extends DockerComposeConnectionDetailsFactory.DockerComposeConnectionDetails
    implements R2dbcConnectionDetails {
        private static final ConnectionFactoryOptionsBuilder connectionFactoryOptionsBuilder = new ConnectionFactoryOptionsBuilder("mysql", 3306);
        private final ConnectionFactoryOptions connectionFactoryOptions;

        MySqlR2dbcDockerComposeConnectionDetails(RunningService service) {
            super(service);
            MySqlEnvironment environment = new MySqlEnvironment(service.env());
            this.connectionFactoryOptions = connectionFactoryOptionsBuilder.build(service, environment.getDatabase(), environment.getUsername(), environment.getPassword());
        }

        public ConnectionFactoryOptions getConnectionFactoryOptions() {
            return this.connectionFactoryOptions;
        }
    }
}

