/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.livereload;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.devtools.livereload.Connection;
import org.springframework.boot.devtools.livereload.ConnectionClosedException;
import org.springframework.core.log.LogMessage;
import org.springframework.util.Assert;

public class LiveReloadServer {
    public static final int DEFAULT_PORT = 35729;
    private static final Log logger = LogFactory.getLog(LiveReloadServer.class);
    private static final int READ_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(4L);
    private final ExecutorService executor = Executors.newCachedThreadPool(new WorkerThreadFactory());
    private final List<Connection> connections = new ArrayList<Connection>();
    private final Object monitor = new Object();
    private final int port;
    private final ThreadFactory threadFactory;
    private @Nullable ServerSocket serverSocket;
    private @Nullable Thread listenThread;

    public LiveReloadServer() {
        this(35729);
    }

    public LiveReloadServer(ThreadFactory threadFactory) {
        this(35729, threadFactory);
    }

    public LiveReloadServer(int port) {
        this(port, Thread::new);
    }

    public LiveReloadServer(int port, ThreadFactory threadFactory) {
        this.port = port;
        this.threadFactory = threadFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int start() throws IOException {
        Object object = this.monitor;
        synchronized (object) {
            Assert.state((!this.isStarted() ? 1 : 0) != 0, (String)"Server already started");
            logger.debug((Object)LogMessage.format((String)"Starting live reload server on port %s", (Object)this.port));
            this.serverSocket = new ServerSocket(this.port);
            int localPort = this.serverSocket.getLocalPort();
            this.listenThread = this.threadFactory.newThread(this::acceptConnections);
            this.listenThread.setDaemon(true);
            this.listenThread.setName("Live Reload Server");
            this.listenThread.start();
            return localPort;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStarted() {
        Object object = this.monitor;
        synchronized (object) {
            return this.listenThread != null;
        }
    }

    public int getPort() {
        return this.port;
    }

    private void acceptConnections() {
        Assert.state((this.serverSocket != null ? 1 : 0) != 0, (String)"'serverSocket' must not be null");
        do {
            try {
                Socket socket = this.serverSocket.accept();
                socket.setSoTimeout(READ_TIMEOUT);
                this.executor.execute(new ConnectionHandler(socket));
            }
            catch (SocketTimeoutException socket) {
            }
            catch (Exception ex) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)"LiveReload server error", (Throwable)ex);
            }
        } while (!this.serverSocket.isClosed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws IOException {
        Object object = this.monitor;
        synchronized (object) {
            if (this.listenThread != null) {
                this.closeAllConnections();
                try {
                    this.executor.shutdown();
                    this.executor.awaitTermination(1L, TimeUnit.MINUTES);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                Assert.state((this.serverSocket != null ? 1 : 0) != 0, (String)"'serverSocket' must not be null");
                this.serverSocket.close();
                try {
                    this.listenThread.join();
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                this.listenThread = null;
                this.serverSocket = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAllConnections() throws IOException {
        List<Connection> list = this.connections;
        synchronized (list) {
            for (Connection connection : this.connections) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerReload() {
        Object object = this.monitor;
        synchronized (object) {
            List<Connection> list = this.connections;
            synchronized (list) {
                for (Connection connection : this.connections) {
                    try {
                        connection.triggerReload();
                    }
                    catch (Exception ex) {
                        logger.debug((Object)"Unable to send reload message", (Throwable)ex);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addConnection(Connection connection) {
        List<Connection> list = this.connections;
        synchronized (list) {
            this.connections.add(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeConnection(Connection connection) {
        List<Connection> list = this.connections;
        synchronized (list) {
            this.connections.remove(connection);
        }
    }

    protected Connection createConnection(Socket socket, InputStream inputStream, OutputStream outputStream) throws IOException {
        return new Connection(socket, inputStream, outputStream);
    }

    private static final class WorkerThreadFactory
    implements ThreadFactory {
        private final AtomicInteger threadNumber = new AtomicInteger(1);

        private WorkerThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            thread.setName("Live Reload #" + this.threadNumber.getAndIncrement());
            return thread;
        }
    }

    private class ConnectionHandler
    implements Runnable {
        private final Socket socket;
        private final InputStream inputStream;

        ConnectionHandler(Socket socket) throws IOException {
            this.socket = socket;
            this.inputStream = socket.getInputStream();
        }

        @Override
        public void run() {
            block3: {
                try {
                    this.handle();
                }
                catch (ConnectionClosedException ex) {
                    logger.debug((Object)"LiveReload connection closed");
                }
                catch (Exception ex) {
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug((Object)"LiveReload error", (Throwable)ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handle() throws Exception {
            try {
                try (OutputStream outputStream = this.socket.getOutputStream();){
                    Connection connection = LiveReloadServer.this.createConnection(this.socket, this.inputStream, outputStream);
                    this.runConnection(connection);
                }
                finally {
                    this.inputStream.close();
                }
            }
            finally {
                this.socket.close();
            }
        }

        private void runConnection(Connection connection) throws Exception {
            try {
                LiveReloadServer.this.addConnection(connection);
                connection.run();
            }
            finally {
                LiveReloadServer.this.removeConnection(connection);
            }
        }
    }
}

