/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.env;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.devtools.system.DevToolsEnablementDeducer;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.env.PropertiesPropertySourceLoader;
import org.springframework.boot.env.PropertySourceLoader;
import org.springframework.boot.env.YamlPropertySourceLoader;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class DevToolsHomePropertiesPostProcessor
implements EnvironmentPostProcessor {
    private static final String LEGACY_FILE_NAME = ".spring-boot-devtools.properties";
    private static final String[] FILE_NAMES = new String[]{"spring-boot-devtools.yml", "spring-boot-devtools.yaml", "spring-boot-devtools.properties"};
    private static final String CONFIG_PATH = "/.config/spring-boot/";
    private static final Set<PropertySourceLoader> PROPERTY_SOURCE_LOADERS;
    private final Properties systemProperties;
    private final Map<String, String> environmentVariables;

    public DevToolsHomePropertiesPostProcessor() {
        this(System.getenv(), System.getProperties());
    }

    DevToolsHomePropertiesPostProcessor(Map<String, String> environmentVariables, Properties systemProperties) {
        this.environmentVariables = environmentVariables;
        this.systemProperties = systemProperties;
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        if (DevToolsEnablementDeducer.shouldEnable(Thread.currentThread())) {
            List<PropertySource<?>> propertySources = this.getPropertySources();
            if (propertySources.isEmpty()) {
                this.addPropertySource(propertySources, LEGACY_FILE_NAME, (File file) -> "devtools-local");
            }
            propertySources.forEach(arg_0 -> ((MutablePropertySources)environment.getPropertySources()).addFirst(arg_0));
        }
    }

    private List<PropertySource<?>> getPropertySources() {
        ArrayList propertySources = new ArrayList();
        for (String fileName : FILE_NAMES) {
            this.addPropertySource(propertySources, CONFIG_PATH + fileName, this::getPropertySourceName);
        }
        return propertySources;
    }

    private String getPropertySourceName(File file) {
        return "devtools-local: [" + String.valueOf(file.toURI()) + "]";
    }

    private void addPropertySource(List<PropertySource<?>> propertySources, String fileName, Function<File, String> propertySourceNamer) {
        FileSystemResource resource;
        File home = this.getHomeDirectory();
        File file = home != null ? new File(home, fileName) : null;
        FileSystemResource fileSystemResource = resource = file != null ? new FileSystemResource(file) : null;
        if (resource != null && resource.exists() && resource.isFile()) {
            this.addPropertySource(propertySources, resource, propertySourceNamer);
        }
    }

    private void addPropertySource(List<PropertySource<?>> propertySources, FileSystemResource resource, Function<File, String> propertySourceNamer) {
        try {
            String name = propertySourceNamer.apply(resource.getFile());
            for (PropertySourceLoader loader : PROPERTY_SOURCE_LOADERS) {
                if (!this.canLoadFileExtension(loader, resource.getFilename())) continue;
                propertySources.addAll(loader.load(name, (Resource)resource));
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException("Unable to load " + resource.getFilename(), ex);
        }
    }

    private boolean canLoadFileExtension(PropertySourceLoader loader, String name) {
        return Arrays.stream(loader.getFileExtensions()).anyMatch(fileExtension -> StringUtils.endsWithIgnoreCase((String)name, (String)fileExtension));
    }

    protected @Nullable File getHomeDirectory() {
        return this.getHomeDirectory(() -> this.environmentVariables.get("SPRING_DEVTOOLS_HOME"), () -> this.systemProperties.getProperty("spring.devtools.home"), () -> this.systemProperties.getProperty("user.home"));
    }

    @SafeVarargs
    private @Nullable File getHomeDirectory(Supplier<String> ... pathSuppliers) {
        for (Supplier<String> pathSupplier : pathSuppliers) {
            String path = pathSupplier.get();
            if (!StringUtils.hasText((String)path)) continue;
            return new File(path);
        }
        return null;
    }

    static {
        HashSet<Object> propertySourceLoaders = new HashSet<Object>();
        propertySourceLoaders.add(new PropertiesPropertySourceLoader());
        if (ClassUtils.isPresent((String)"org.yaml.snakeyaml.Yaml", null)) {
            propertySourceLoaders.add(new YamlPropertySourceLoader());
        }
        PROPERTY_SOURCE_LOADERS = Collections.unmodifiableSet(propertySourceLoaders);
    }
}

