/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.filewatch;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.boot.devtools.filewatch.ChangedFile;
import org.springframework.boot.devtools.filewatch.ChangedFiles;
import org.springframework.boot.devtools.filewatch.FileSnapshot;
import org.springframework.util.Assert;

class DirectorySnapshot {
    private static final Set<String> DOTS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(".", "..")));
    private final File directory;
    private final Date time;
    private final Set<FileSnapshot> files;

    DirectorySnapshot(File directory) {
        Assert.notNull((Object)directory, (String)"Directory must not be null");
        Assert.isTrue((!directory.isFile() ? 1 : 0) != 0, () -> "Directory '" + String.valueOf(directory) + "' must not be a file");
        this.directory = directory;
        this.time = new Date();
        LinkedHashSet<FileSnapshot> files = new LinkedHashSet<FileSnapshot>();
        this.collectFiles(directory, files);
        this.files = Collections.unmodifiableSet(files);
    }

    private void collectFiles(File source, Set<FileSnapshot> result) {
        File[] children = source.listFiles();
        if (children != null) {
            for (File child : children) {
                if (child.isDirectory() && !DOTS.contains(child.getName())) {
                    this.collectFiles(child, result);
                    continue;
                }
                if (!child.isFile()) continue;
                result.add(new FileSnapshot(child));
            }
        }
    }

    ChangedFiles getChangedFiles(DirectorySnapshot snapshot, FileFilter triggerFilter) {
        Assert.notNull((Object)snapshot, (String)"Snapshot must not be null");
        File directory = this.directory;
        Assert.isTrue((boolean)snapshot.directory.equals(directory), () -> "Snapshot source directory must be '" + String.valueOf(directory) + "'");
        LinkedHashSet<ChangedFile> changes = new LinkedHashSet<ChangedFile>();
        Map<File, FileSnapshot> previousFiles = this.getFilesMap();
        for (FileSnapshot currentFile : snapshot.files) {
            if (!this.acceptChangedFile(triggerFilter, currentFile)) continue;
            FileSnapshot previousFile = previousFiles.remove(currentFile.getFile());
            if (previousFile == null) {
                changes.add(new ChangedFile(directory, currentFile.getFile(), ChangedFile.Type.ADD));
                continue;
            }
            if (previousFile.equals(currentFile)) continue;
            changes.add(new ChangedFile(directory, currentFile.getFile(), ChangedFile.Type.MODIFY));
        }
        for (FileSnapshot previousFile : previousFiles.values()) {
            if (!this.acceptChangedFile(triggerFilter, previousFile)) continue;
            changes.add(new ChangedFile(directory, previousFile.getFile(), ChangedFile.Type.DELETE));
        }
        return new ChangedFiles(directory, changes);
    }

    private boolean acceptChangedFile(FileFilter triggerFilter, FileSnapshot file) {
        return triggerFilter == null || !triggerFilter.accept(file.getFile());
    }

    private Map<File, FileSnapshot> getFilesMap() {
        LinkedHashMap<File, FileSnapshot> files = new LinkedHashMap<File, FileSnapshot>();
        for (FileSnapshot file : this.files) {
            files.put(file.getFile(), file);
        }
        return files;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof DirectorySnapshot) {
            DirectorySnapshot other = (DirectorySnapshot)obj;
            return this.equals(other, null);
        }
        return super.equals(obj);
    }

    boolean equals(DirectorySnapshot other, FileFilter filter) {
        if (this.directory.equals(other.directory)) {
            Set<FileSnapshot> ourFiles = this.filter(this.files, filter);
            Set<FileSnapshot> otherFiles = this.filter(other.files, filter);
            return ourFiles.equals(otherFiles);
        }
        return false;
    }

    private Set<FileSnapshot> filter(Set<FileSnapshot> source, FileFilter filter) {
        if (filter == null) {
            return source;
        }
        LinkedHashSet<FileSnapshot> filtered = new LinkedHashSet<FileSnapshot>();
        for (FileSnapshot file : source) {
            if (!filter.accept(file.getFile())) continue;
            filtered.add(file);
        }
        return filtered;
    }

    public int hashCode() {
        int hashCode = this.directory.hashCode();
        hashCode = 31 * hashCode + this.files.hashCode();
        return hashCode;
    }

    File getDirectory() {
        return this.directory;
    }

    public String toString() {
        return String.valueOf(this.directory) + " snapshot at " + String.valueOf(this.time);
    }
}

