/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.restart;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.event.ApplicationFailedEvent;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.boot.context.event.ApplicationStartingEvent;
import org.springframework.boot.devtools.restart.AgentReloader;
import org.springframework.boot.devtools.restart.DefaultRestartInitializer;
import org.springframework.boot.devtools.restart.Restarter;
import org.springframework.boot.devtools.system.DevToolsEnablementDeducer;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.log.LogMessage;

public class RestartApplicationListener
implements ApplicationListener<ApplicationEvent>,
Ordered {
    private static final String ENABLED_PROPERTY = "spring.devtools.restart.enabled";
    private static final Log logger = LogFactory.getLog(RestartApplicationListener.class);
    private int order = Integer.MIN_VALUE;

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ApplicationStartingEvent) {
            ApplicationStartingEvent startingEvent = (ApplicationStartingEvent)event;
            this.onApplicationStartingEvent(startingEvent);
        }
        if (event instanceof ApplicationPreparedEvent) {
            ApplicationPreparedEvent preparedEvent = (ApplicationPreparedEvent)event;
            this.onApplicationPreparedEvent(preparedEvent);
        }
        if (event instanceof ApplicationReadyEvent || event instanceof ApplicationFailedEvent) {
            Restarter.getInstance().finish();
        }
        if (event instanceof ApplicationFailedEvent) {
            ApplicationFailedEvent failedEvent = (ApplicationFailedEvent)event;
            this.onApplicationFailedEvent(failedEvent);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onApplicationStartingEvent(ApplicationStartingEvent event) {
        boolean restartOnInitialize;
        String enabled = System.getProperty(ENABLED_PROPERTY);
        DefaultRestartInitializer restartInitializer = null;
        if (enabled == null) {
            if (!this.implicitlyEnableRestart()) {
                logger.info((Object)"Restart disabled due to context in which it is running");
                Restarter.disable();
                return;
            }
            restartInitializer = new DefaultRestartInitializer();
        } else if (Boolean.parseBoolean(enabled)) {
            restartInitializer = new DefaultRestartInitializer(){

                @Override
                protected boolean isDevelopmentClassLoader(ClassLoader classLoader) {
                    return true;
                }
            };
            logger.info((Object)LogMessage.format((String)"Restart enabled irrespective of application packaging due to System property '%s' being set to true", (Object)ENABLED_PROPERTY));
        }
        if (restartInitializer == null) {
            logger.info((Object)LogMessage.format((String)"Restart disabled due to System property '%s' being set to false", (Object)ENABLED_PROPERTY));
            Restarter.disable();
            return;
        }
        String[] args = event.getArgs();
        boolean bl = restartOnInitialize = !AgentReloader.isActive();
        if (!restartOnInitialize) {
            logger.info((Object)"Restart disabled due to an agent-based reloader being active");
        }
        Restarter.initialize(args, false, restartInitializer, restartOnInitialize);
    }

    boolean implicitlyEnableRestart() {
        return DevToolsEnablementDeducer.shouldEnable(Thread.currentThread());
    }

    private void onApplicationPreparedEvent(ApplicationPreparedEvent event) {
        Restarter.getInstance().prepare(event.getApplicationContext());
    }

    private void onApplicationFailedEvent(ApplicationFailedEvent event) {
        Restarter.getInstance().remove(event.getApplicationContext());
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}

