/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.restart;

import org.springframework.boot.context.event.ApplicationFailedEvent;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.boot.context.event.ApplicationStartingEvent;
import org.springframework.boot.devtools.restart.AgentReloader;
import org.springframework.boot.devtools.restart.DefaultRestartInitializer;
import org.springframework.boot.devtools.restart.Restarter;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;

public class RestartApplicationListener
implements ApplicationListener<ApplicationEvent>,
Ordered {
    private int order = Integer.MIN_VALUE;
    private static final String ENABLED_PROPERTY = "spring.devtools.restart.enabled";

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ApplicationStartingEvent) {
            this.onApplicationStartingEvent((ApplicationStartingEvent)event);
        }
        if (event instanceof ApplicationPreparedEvent) {
            this.onApplicationPreparedEvent((ApplicationPreparedEvent)event);
        }
        if (event instanceof ApplicationReadyEvent || event instanceof ApplicationFailedEvent) {
            Restarter.getInstance().finish();
        }
        if (event instanceof ApplicationFailedEvent) {
            this.onApplicationFailedEvent((ApplicationFailedEvent)event);
        }
    }

    private void onApplicationStartingEvent(ApplicationStartingEvent event) {
        String enabled = System.getProperty(ENABLED_PROPERTY);
        if (enabled == null || Boolean.parseBoolean(enabled)) {
            String[] args = event.getArgs();
            DefaultRestartInitializer initializer = new DefaultRestartInitializer();
            boolean restartOnInitialize = !AgentReloader.isActive();
            Restarter.initialize(args, false, initializer, restartOnInitialize);
        } else {
            Restarter.disable();
        }
    }

    private void onApplicationPreparedEvent(ApplicationPreparedEvent event) {
        Restarter.getInstance().prepare(event.getApplicationContext());
    }

    private void onApplicationFailedEvent(ApplicationFailedEvent event) {
        Restarter.getInstance().remove(event.getApplicationContext());
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}

