/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.data.redis.autoconfigure;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.data.redis.autoconfigure.DataRedisConnectionDetails;
import org.springframework.boot.data.redis.autoconfigure.DataRedisProperties;
import org.springframework.boot.data.redis.autoconfigure.JedisConnectionConfiguration;
import org.springframework.boot.data.redis.autoconfigure.LettuceConnectionConfiguration;
import org.springframework.boot.data.redis.autoconfigure.PropertiesDataRedisConnectionDetails;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;

@AutoConfiguration
@ConditionalOnClass(value={RedisOperations.class})
@EnableConfigurationProperties(value={DataRedisProperties.class})
@Import(value={LettuceConnectionConfiguration.class, JedisConnectionConfiguration.class})
public final class DataRedisAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={DataRedisConnectionDetails.class})
    PropertiesDataRedisConnectionDetails redisConnectionDetails(DataRedisProperties properties, ObjectProvider<SslBundles> sslBundles) {
        return new PropertiesDataRedisConnectionDetails(properties, (SslBundles)sslBundles.getIfAvailable());
    }

    @Bean
    @ConditionalOnMissingBean(name={"redisTemplate"})
    @ConditionalOnSingleCandidate(value=RedisConnectionFactory.class)
    RedisTemplate<Object, Object> redisTemplate(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory(redisConnectionFactory);
        return template;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnSingleCandidate(value=RedisConnectionFactory.class)
    StringRedisTemplate stringRedisTemplate(RedisConnectionFactory redisConnectionFactory) {
        return new StringRedisTemplate(redisConnectionFactory);
    }
}

