/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.data.redis.docker.compose;

import org.springframework.boot.data.redis.autoconfigure.RedisConnectionDetails;
import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionDetailsFactory;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionSource;

class RedisDockerComposeConnectionDetailsFactory
extends DockerComposeConnectionDetailsFactory<RedisConnectionDetails> {
    private static final String[] REDIS_CONTAINER_NAMES = new String[]{"redis", "bitnami/redis", "redis/redis-stack", "redis/redis-stack-server"};
    private static final int REDIS_PORT = 6379;

    RedisDockerComposeConnectionDetailsFactory() {
        super(REDIS_CONTAINER_NAMES, new String[0]);
    }

    protected RedisConnectionDetails getDockerComposeConnectionDetails(DockerComposeConnectionSource source) {
        return new RedisDockerComposeConnectionDetails(source.getRunningService());
    }

    static class RedisDockerComposeConnectionDetails
    extends DockerComposeConnectionDetailsFactory.DockerComposeConnectionDetails
    implements RedisConnectionDetails {
        private final RedisConnectionDetails.Standalone standalone;

        RedisDockerComposeConnectionDetails(RunningService service) {
            super(service);
            this.standalone = RedisConnectionDetails.Standalone.of(service.host(), service.ports().get(6379), this.getSslBundle(service));
        }

        @Override
        public RedisConnectionDetails.Standalone getStandalone() {
            return this.standalone;
        }
    }
}

