/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.data.mongodb.health;

import org.bson.Document;
import org.springframework.boot.health.contributor.AbstractReactiveHealthIndicator;
import org.springframework.boot.health.contributor.Health;
import org.springframework.data.mongodb.core.ReactiveMongoTemplate;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class MongoReactiveHealthIndicator
extends AbstractReactiveHealthIndicator {
    private final ReactiveMongoTemplate reactiveMongoTemplate;

    public MongoReactiveHealthIndicator(ReactiveMongoTemplate reactiveMongoTemplate) {
        super("Mongo health check failed");
        Assert.notNull((Object)reactiveMongoTemplate, (String)"'reactiveMongoTemplate' must not be null");
        this.reactiveMongoTemplate = reactiveMongoTemplate;
    }

    protected Mono<Health> doHealthCheck(Health.Builder builder) {
        Mono buildInfo = this.reactiveMongoTemplate.executeCommand("{ hello: 1 }");
        return buildInfo.map(document -> this.up(builder, (Document)document));
    }

    private Health up(Health.Builder builder, Document document) {
        return builder.up().withDetail("maxWireVersion", (Object)document.getInteger((Object)"maxWireVersion")).build();
    }
}

