/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.data.mongodb.autoconfigure.health;

import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.data.mongodb.autoconfigure.MongoReactiveDataAutoConfiguration;
import org.springframework.boot.data.mongodb.health.MongoReactiveHealthIndicator;
import org.springframework.boot.health.autoconfigure.contributor.CompositeReactiveHealthContributorConfiguration;
import org.springframework.boot.health.autoconfigure.contributor.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.health.contributor.ReactiveHealthContributor;
import org.springframework.context.annotation.Bean;
import org.springframework.data.mongodb.core.ReactiveMongoTemplate;
import reactor.core.publisher.Flux;

@AutoConfiguration(after={MongoReactiveDataAutoConfiguration.class})
@ConditionalOnClass(value={ReactiveMongoTemplate.class, Flux.class, MongoReactiveHealthIndicator.class, ConditionalOnEnabledHealthIndicator.class})
@ConditionalOnBean(value={ReactiveMongoTemplate.class})
@ConditionalOnEnabledHealthIndicator(value="mongo")
public class MongoReactiveHealthContributorAutoConfiguration
extends CompositeReactiveHealthContributorConfiguration<MongoReactiveHealthIndicator, ReactiveMongoTemplate> {
    public MongoReactiveHealthContributorAutoConfiguration() {
        super(MongoReactiveHealthIndicator::new);
    }

    @Bean
    @ConditionalOnMissingBean(name={"mongoHealthIndicator", "mongoHealthContributor"})
    public ReactiveHealthContributor mongoHealthContributor(ConfigurableListableBeanFactory beanFactory) {
        return (ReactiveHealthContributor)this.createContributor(beanFactory, ReactiveMongoTemplate.class);
    }
}

