/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.data.elasticsearch.health;

import co.elastic.clients.elasticsearch._types.HealthStatus;
import co.elastic.clients.elasticsearch.cluster.HealthResponse;
import org.springframework.boot.health.contributor.AbstractReactiveHealthIndicator;
import org.springframework.boot.health.contributor.Health;
import org.springframework.boot.health.contributor.Status;
import org.springframework.data.elasticsearch.client.elc.ReactiveElasticsearchClient;
import reactor.core.publisher.Mono;

public class DataElasticsearchReactiveHealthIndicator
extends AbstractReactiveHealthIndicator {
    private final ReactiveElasticsearchClient client;

    public DataElasticsearchReactiveHealthIndicator(ReactiveElasticsearchClient client) {
        super("Elasticsearch health check failed");
        this.client = client;
    }

    protected Mono<Health> doHealthCheck(Health.Builder builder) {
        return this.client.cluster().health(b -> b).map(response -> this.processResponse(builder, (HealthResponse)response));
    }

    private Health processResponse(Health.Builder builder, HealthResponse response) {
        if (!response.timedOut()) {
            HealthStatus status = response.status();
            builder.status(HealthStatus.Red == status ? Status.OUT_OF_SERVICE : Status.UP);
            builder.withDetail("cluster_name", (Object)response.clusterName());
            builder.withDetail("status", (Object)response.status().jsonValue());
            builder.withDetail("timed_out", (Object)response.timedOut());
            builder.withDetail("number_of_nodes", (Object)response.numberOfNodes());
            builder.withDetail("number_of_data_nodes", (Object)response.numberOfDataNodes());
            builder.withDetail("active_primary_shards", (Object)response.activePrimaryShards());
            builder.withDetail("active_shards", (Object)response.activeShards());
            builder.withDetail("relocating_shards", (Object)response.relocatingShards());
            builder.withDetail("initializing_shards", (Object)response.initializingShards());
            builder.withDetail("unassigned_shards", (Object)response.unassignedShards());
            builder.withDetail("delayed_unassigned_shards", (Object)response.delayedUnassignedShards());
            builder.withDetail("number_of_pending_tasks", (Object)response.numberOfPendingTasks());
            builder.withDetail("number_of_in_flight_fetch", (Object)response.numberOfInFlightFetch());
            builder.withDetail("task_max_waiting_in_queue_millis", (Object)response.taskMaxWaitingInQueueMillis());
            builder.withDetail("active_shards_percent_as_number", (Object)response.activeShardsPercentAsNumber());
            builder.withDetail("unassigned_primary_shards", (Object)response.unassignedPrimaryShards());
            return builder.build();
        }
        return builder.down().build();
    }
}

