/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.data.couchbase.autoconfigure;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.couchbase.CouchbaseClientFactory;
import org.springframework.data.couchbase.core.ReactiveCouchbaseOperations;
import org.springframework.data.couchbase.core.ReactiveCouchbaseTemplate;
import org.springframework.data.couchbase.core.convert.CouchbaseConverter;
import org.springframework.data.couchbase.core.convert.MappingCouchbaseConverter;
import org.springframework.data.couchbase.repository.config.ReactiveRepositoryOperationsMapping;

@Configuration(proxyBeanMethods=false)
@ConditionalOnSingleCandidate(value=CouchbaseClientFactory.class)
class CouchbaseReactiveDataConfiguration {
    CouchbaseReactiveDataConfiguration() {
    }

    @Bean(name={"reactiveCouchbaseTemplate"})
    @ConditionalOnMissingBean(name={"reactiveCouchbaseTemplate"})
    ReactiveCouchbaseTemplate reactiveCouchbaseTemplate(CouchbaseClientFactory couchbaseClientFactory, MappingCouchbaseConverter mappingCouchbaseConverter) {
        return new ReactiveCouchbaseTemplate(couchbaseClientFactory, (CouchbaseConverter)mappingCouchbaseConverter);
    }

    @Bean(name={"reactiveCouchbaseRepositoryOperationsMapping"})
    @ConditionalOnMissingBean(name={"reactiveCouchbaseRepositoryOperationsMapping"})
    ReactiveRepositoryOperationsMapping reactiveCouchbaseRepositoryOperationsMapping(ReactiveCouchbaseTemplate reactiveCouchbaseTemplate) {
        return new ReactiveRepositoryOperationsMapping((ReactiveCouchbaseOperations)reactiveCouchbaseTemplate);
    }
}

