/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.data.couchbase.autoconfigure;

import com.couchbase.client.java.Bucket;
import jakarta.validation.Validator;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.couchbase.autoconfigure.CouchbaseAutoConfiguration;
import org.springframework.boot.data.couchbase.autoconfigure.CouchbaseClientFactoryConfiguration;
import org.springframework.boot.data.couchbase.autoconfigure.CouchbaseClientFactoryDependentConfiguration;
import org.springframework.boot.data.couchbase.autoconfigure.CouchbaseDataConfiguration;
import org.springframework.boot.data.couchbase.autoconfigure.CouchbaseDataProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.data.couchbase.core.mapping.event.ValidatingCouchbaseEventListener;
import org.springframework.data.couchbase.repository.CouchbaseRepository;

@AutoConfiguration(after={CouchbaseAutoConfiguration.class}, afterName={"org.springframework.boot.validation.autoconfigure.ValidationAutoConfiguration"})
@ConditionalOnClass(value={Bucket.class, CouchbaseRepository.class})
@EnableConfigurationProperties(value={CouchbaseDataProperties.class})
@Import(value={CouchbaseDataConfiguration.class, CouchbaseClientFactoryConfiguration.class, CouchbaseClientFactoryDependentConfiguration.class})
public class CouchbaseDataAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Validator.class})
    public static class ValidationConfiguration {
        @Bean
        @ConditionalOnSingleCandidate(value=Validator.class)
        public ValidatingCouchbaseEventListener validationEventListener(Validator validator) {
            return new ValidatingCouchbaseEventListener(validator);
        }
    }
}

