/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cloudfoundry.actuate.autoconfigure.endpoint;

import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.EndpointExposureOutcomeContributor;
import org.springframework.boot.actuate.autoconfigure.endpoint.expose.EndpointExposure;
import org.springframework.boot.actuate.autoconfigure.endpoint.expose.IncludeExcludeEndpointFilter;
import org.springframework.boot.actuate.endpoint.EndpointId;
import org.springframework.boot.actuate.endpoint.ExposableEndpoint;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.core.env.Environment;

class CloudFoundryEndpointExposureOutcomeContributor
implements EndpointExposureOutcomeContributor {
    private static final String PROPERTY = "management.endpoints.cloud-foundry.exposure";
    private final @Nullable IncludeExcludeEndpointFilter<?> filter;

    CloudFoundryEndpointExposureOutcomeContributor(Environment environment) {
        this.filter = !CloudPlatform.CLOUD_FOUNDRY.isActive(environment) ? null : new IncludeExcludeEndpointFilter(ExposableEndpoint.class, environment, PROPERTY, new String[]{"*"});
    }

    public @Nullable ConditionOutcome getExposureOutcome(EndpointId endpointId, Set<EndpointExposure> exposures, ConditionMessage.Builder message) {
        if (exposures.contains(EndpointExposure.WEB) && this.filter != null && this.filter.match(endpointId)) {
            return ConditionOutcome.match((ConditionMessage)message.because("marked as exposed by a 'management.endpoints.cloud-foundry.exposure' property"));
        }
        return null;
    }
}

