/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.compiler.autoconfigure;

import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.springframework.boot.cli.compiler.AstUtils;
import org.springframework.boot.cli.compiler.CompilerAutoConfiguration;
import org.springframework.boot.cli.compiler.DependencyCustomizer;

public class SpringWebsocketCompilerAutoConfiguration
extends CompilerAutoConfiguration {
    public boolean matches(ClassNode classNode) {
        return AstUtils.hasAtLeastOneAnnotation((ClassNode)classNode, (String[])new String[]{"EnableWebSocket", "EnableWebSocketMessageBroker"});
    }

    public void applyDependencies(DependencyCustomizer dependencies) {
        dependencies.ifAnyMissingClasses(new String[]{"org.springframework.web.socket.config.annotation.EnableWebSocket"}).add(new String[]{"spring-boot-starter-websocket"}).add(new String[]{"spring-messaging"});
    }

    public void applyImports(ImportCustomizer imports) {
        imports.addStarImports(new String[]{"org.springframework.messaging.handler.annotation", "org.springframework.messaging.simp.config", "org.springframework.web.socket.handler", "org.springframework.web.socket.sockjs.transport.handler", "org.springframework.web.socket.config.annotation"}).addImports(new String[]{"org.springframework.web.socket.WebSocketHandler"});
    }
}

