/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cassandra.testcontainers;

import java.net.InetSocketAddress;
import java.util.List;
import org.springframework.boot.cassandra.autoconfigure.CassandraConnectionDetails;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.testcontainers.cassandra.CassandraContainer;

class CassandraContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<CassandraContainer, CassandraConnectionDetails> {
    CassandraContainerConnectionDetailsFactory() {
    }

    protected CassandraConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<CassandraContainer> source) {
        return new CassandraContainerConnectionDetails(source);
    }

    private static final class CassandraContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails<CassandraContainer>
    implements CassandraConnectionDetails {
        private CassandraContainerConnectionDetails(ContainerConnectionSource<CassandraContainer> source) {
            super(source);
        }

        @Override
        public List<CassandraConnectionDetails.Node> getContactPoints() {
            InetSocketAddress contactPoint = ((CassandraContainer)this.getContainer()).getContactPoint();
            return List.of(new CassandraConnectionDetails.Node(contactPoint.getHostString(), contactPoint.getPort()));
        }

        @Override
        public String getUsername() {
            return ((CassandraContainer)this.getContainer()).getUsername();
        }

        @Override
        public String getPassword() {
            return ((CassandraContainer)this.getContainer()).getPassword();
        }

        @Override
        public String getLocalDatacenter() {
            return ((CassandraContainer)this.getContainer()).getLocalDatacenter();
        }

        @Override
        public SslBundle getSslBundle() {
            return super.getSslBundle();
        }
    }
}

