/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.task;

import java.time.Duration;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="spring.task.execution")
public class TaskExecutionProperties {
    private final Pool pool = new Pool();
    private final Simple simple = new Simple();
    private final Shutdown shutdown = new Shutdown();
    private Mode mode = Mode.AUTO;
    private String threadNamePrefix = "task-";

    public Simple getSimple() {
        return this.simple;
    }

    public Pool getPool() {
        return this.pool;
    }

    public Shutdown getShutdown() {
        return this.shutdown;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public String getThreadNamePrefix() {
        return this.threadNamePrefix;
    }

    public void setThreadNamePrefix(String threadNamePrefix) {
        this.threadNamePrefix = threadNamePrefix;
    }

    public static class Pool {
        private int queueCapacity = Integer.MAX_VALUE;
        private int coreSize = 8;
        private int maxSize = Integer.MAX_VALUE;
        private boolean allowCoreThreadTimeout = true;
        private Duration keepAlive = Duration.ofSeconds(60L);
        private final Shutdown shutdown = new Shutdown();

        public int getQueueCapacity() {
            return this.queueCapacity;
        }

        public void setQueueCapacity(int queueCapacity) {
            this.queueCapacity = queueCapacity;
        }

        public int getCoreSize() {
            return this.coreSize;
        }

        public void setCoreSize(int coreSize) {
            this.coreSize = coreSize;
        }

        public int getMaxSize() {
            return this.maxSize;
        }

        public void setMaxSize(int maxSize) {
            this.maxSize = maxSize;
        }

        public boolean isAllowCoreThreadTimeout() {
            return this.allowCoreThreadTimeout;
        }

        public void setAllowCoreThreadTimeout(boolean allowCoreThreadTimeout) {
            this.allowCoreThreadTimeout = allowCoreThreadTimeout;
        }

        public Duration getKeepAlive() {
            return this.keepAlive;
        }

        public void setKeepAlive(Duration keepAlive) {
            this.keepAlive = keepAlive;
        }

        public Shutdown getShutdown() {
            return this.shutdown;
        }

        public static class Shutdown {
            private boolean acceptTasksAfterContextClose;

            public boolean isAcceptTasksAfterContextClose() {
                return this.acceptTasksAfterContextClose;
            }

            public void setAcceptTasksAfterContextClose(boolean acceptTasksAfterContextClose) {
                this.acceptTasksAfterContextClose = acceptTasksAfterContextClose;
            }
        }
    }

    public static class Simple {
        private boolean cancelRemainingTasksOnClose;
        private boolean rejectTasksWhenLimitReached;
        private @Nullable Integer concurrencyLimit;

        public boolean isCancelRemainingTasksOnClose() {
            return this.cancelRemainingTasksOnClose;
        }

        public void setCancelRemainingTasksOnClose(boolean cancelRemainingTasksOnClose) {
            this.cancelRemainingTasksOnClose = cancelRemainingTasksOnClose;
        }

        public boolean isRejectTasksWhenLimitReached() {
            return this.rejectTasksWhenLimitReached;
        }

        public void setRejectTasksWhenLimitReached(boolean rejectTasksWhenLimitReached) {
            this.rejectTasksWhenLimitReached = rejectTasksWhenLimitReached;
        }

        public @Nullable Integer getConcurrencyLimit() {
            return this.concurrencyLimit;
        }

        public void setConcurrencyLimit(@Nullable Integer concurrencyLimit) {
            this.concurrencyLimit = concurrencyLimit;
        }
    }

    public static class Shutdown {
        private boolean awaitTermination;
        private @Nullable Duration awaitTerminationPeriod;

        public boolean isAwaitTermination() {
            return this.awaitTermination;
        }

        public void setAwaitTermination(boolean awaitTermination) {
            this.awaitTermination = awaitTermination;
        }

        public @Nullable Duration getAwaitTerminationPeriod() {
            return this.awaitTerminationPeriod;
        }

        public void setAwaitTerminationPeriod(@Nullable Duration awaitTerminationPeriod) {
            this.awaitTerminationPeriod = awaitTerminationPeriod;
        }
    }

    public static enum Mode {
        AUTO,
        FORCE;

    }
}

