/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.http.client.reactive;

import java.util.List;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.http.client.reactive.ClientHttpConnectorBuilderCustomizer;
import org.springframework.boot.autoconfigure.http.client.reactive.ClientHttpConnectors;
import org.springframework.boot.autoconfigure.http.client.reactive.ConditionalOnClientHttpConnectorBuilderDetection;
import org.springframework.boot.autoconfigure.http.client.reactive.HttpReactiveClientProperties;
import org.springframework.boot.autoconfigure.reactor.netty.ReactorNettyConfigurations;
import org.springframework.boot.autoconfigure.ssl.SslAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.http.client.reactive.ClientHttpConnectorBuilder;
import org.springframework.boot.http.client.reactive.ClientHttpConnectorSettings;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.boot.util.LambdaSafe;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.client.reactive.ClientHttpConnector;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;

@AutoConfiguration(after={SslAutoConfiguration.class})
@ConditionalOnClass(value={ClientHttpConnector.class, Mono.class})
@Conditional(value={ConditionalOnClientHttpConnectorBuilderDetection.class})
@EnableConfigurationProperties(value={HttpReactiveClientProperties.class})
public class ClientHttpConnectorAutoConfiguration
implements BeanClassLoaderAware {
    private final ClientHttpConnectors connectors;
    private ClassLoader beanClassLoader;

    ClientHttpConnectorAutoConfiguration(ObjectProvider<SslBundles> sslBundles, HttpReactiveClientProperties properties) {
        this.connectors = new ClientHttpConnectors(sslBundles, properties);
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    @Bean
    @ConditionalOnMissingBean
    ClientHttpConnectorBuilder<?> clientHttpConnectorBuilder(ObjectProvider<ClientHttpConnectorBuilderCustomizer<?>> clientHttpConnectorBuilderCustomizers) {
        ClientHttpConnectorBuilder<?> builder = this.connectors.builder(this.beanClassLoader);
        return this.customize(builder, clientHttpConnectorBuilderCustomizers.orderedStream().toList());
    }

    private ClientHttpConnectorBuilder<?> customize(ClientHttpConnectorBuilder<?> builder, List<ClientHttpConnectorBuilderCustomizer<?>> customizers) {
        ClientHttpConnectorBuilder[] builderReference = new ClientHttpConnectorBuilder[]{builder};
        LambdaSafe.callbacks(ClientHttpConnectorBuilderCustomizer.class, customizers, (Object)builderReference[0], (Object[])new Object[0]).invoke(customizer -> {
            builderReference[0] = customizer.customize(builderReference[0]);
        });
        return builderReference[0];
    }

    @Bean
    @ConditionalOnMissingBean
    ClientHttpConnectorSettings clientHttpConnectorSettings() {
        return this.connectors.settings();
    }

    @Bean
    @Lazy
    @ConditionalOnMissingBean
    ClientHttpConnector clientHttpConnector(ClientHttpConnectorBuilder<?> clientHttpConnectorBuilder, ClientHttpConnectorSettings clientHttpRequestFactorySettings) {
        return clientHttpConnectorBuilder.build(clientHttpRequestFactorySettings);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={HttpClient.class})
    @Import(value={ReactorNettyConfigurations.ReactorResourceFactoryConfiguration.class})
    static class ReactorNetty {
        ReactorNetty() {
        }
    }
}

