/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.orm.jpa;

import java.util.List;
import javax.sql.DataSource;
import org.springframework.boot.jdbc.EmbeddedDatabaseConnection;
import org.springframework.boot.jdbc.SchemaManagement;
import org.springframework.boot.jdbc.SchemaManagementProvider;

class HibernateDefaultDdlAutoProvider
implements SchemaManagementProvider {
    private final List<SchemaManagementProvider> providers;

    HibernateDefaultDdlAutoProvider(List<SchemaManagementProvider> providers) {
        this.providers = providers;
    }

    public String getDefaultDdlAuto(DataSource dataSource) {
        if (!EmbeddedDatabaseConnection.isEmbedded((DataSource)dataSource)) {
            return "none";
        }
        SchemaManagement schemaManagement = this.getSchemaManagement(dataSource);
        if (SchemaManagement.MANAGED.equals((Object)schemaManagement)) {
            return "none";
        }
        return "create-drop";
    }

    public SchemaManagement getSchemaManagement(DataSource dataSource) {
        for (SchemaManagementProvider provider : this.providers) {
            SchemaManagement schemaManagement = provider.getSchemaManagement(dataSource);
            if (!SchemaManagement.MANAGED.equals((Object)schemaManagement)) continue;
            return schemaManagement;
        }
        return SchemaManagement.UNMANAGED;
    }
}

