/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.velocity;

import java.io.IOException;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.servlet.Servlet;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.exception.VelocityException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnNotWebApplication;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.velocity.VelocityProperties;
import org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.ui.velocity.VelocityEngineFactory;
import org.springframework.ui.velocity.VelocityEngineFactoryBean;
import org.springframework.util.Assert;
import org.springframework.web.servlet.view.velocity.VelocityConfig;
import org.springframework.web.servlet.view.velocity.VelocityConfigurer;
import org.springframework.web.servlet.view.velocity.VelocityViewResolver;

@Configuration
@ConditionalOnClass(value={VelocityEngine.class, VelocityEngineFactory.class})
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class})
@EnableConfigurationProperties(value={VelocityProperties.class})
public class VelocityAutoConfiguration {
    @Autowired
    private final ResourceLoader resourceLoader = new DefaultResourceLoader();
    @Autowired
    private VelocityProperties properties;

    @PostConstruct
    public void checkTemplateLocationExists() {
        if (this.properties.isCheckTemplateLocation()) {
            Resource resource = this.resourceLoader.getResource(this.properties.getResourceLoaderPath());
            Assert.state((boolean)resource.exists(), (String)("Cannot find template location: " + resource + " (please add some templates, check your Velocity configuration, " + "or set spring.velocity.checkTemplateLocation=false)"));
        }
    }

    @Configuration
    @ConditionalOnClass(value={Servlet.class})
    @ConditionalOnWebApplication
    public static class VelocityWebConfiguration
    extends VelocityConfiguration {
        @Bean
        @ConditionalOnMissingBean(value={VelocityConfig.class})
        public VelocityConfigurer velocityConfigurer() {
            VelocityConfigurer configurer = new VelocityConfigurer();
            this.applyProperties((VelocityEngineFactory)configurer);
            return configurer;
        }

        @Bean
        public VelocityEngine velocityEngine(VelocityConfigurer configurer) throws VelocityException, IOException {
            return configurer.getVelocityEngine();
        }

        @Bean
        @ConditionalOnMissingBean(name={"velocityViewResolver"})
        public VelocityViewResolver velocityViewResolver() {
            VelocityViewResolver resolver = new VelocityViewResolver();
            this.properties.applyToViewResolver(resolver);
            return resolver;
        }
    }

    @Configuration
    @ConditionalOnNotWebApplication
    public static class VelocityNonWebConfiguration
    extends VelocityConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public VelocityEngineFactoryBean velocityConfiguration() {
            VelocityEngineFactoryBean velocityEngineFactoryBean = new VelocityEngineFactoryBean();
            this.applyProperties((VelocityEngineFactory)velocityEngineFactoryBean);
            return velocityEngineFactoryBean;
        }
    }

    protected static class VelocityConfiguration {
        @Autowired
        protected VelocityProperties properties;

        protected VelocityConfiguration() {
        }

        protected void applyProperties(VelocityEngineFactory factory) {
            factory.setResourceLoaderPath(this.properties.getResourceLoaderPath());
            Properties velocityProperties = new Properties();
            velocityProperties.putAll(this.properties.getProperties());
            factory.setVelocityProperties(velocityProperties);
        }
    }
}

