/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jms.activemq;

import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.pool.PooledConnectionFactory;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="spring.activemq")
public class ActiveMQProperties {
    public static final String DEFAULT_EMBEDDED_BROKER_URL = "vm://localhost?broker.persistent=false";
    public static final String DEFAULT_NETWORK_BROKER_URL = "tcp://localhost:61616";
    private String brokerUrl;
    private boolean inMemory = true;
    private boolean pooled;
    private String user;
    private String password;

    public String getBrokerUrl() {
        return this.brokerUrl;
    }

    public void setBrokerUrl(String brokerUrl) {
        this.brokerUrl = brokerUrl;
    }

    public boolean isInMemory() {
        return this.inMemory;
    }

    public void setInMemory(boolean inMemory) {
        this.inMemory = inMemory;
    }

    public boolean isPooled() {
        return this.pooled;
    }

    public void setPooled(boolean pooled) {
        this.pooled = pooled;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public ConnectionFactory createConnectionFactory() {
        ConnectionFactory connectionFactory = this.createActiveMQConnectionFactory();
        if (this.isPooled()) {
            PooledConnectionFactory pool = new PooledConnectionFactory();
            pool.setConnectionFactory(connectionFactory);
            return pool;
        }
        return connectionFactory;
    }

    private ConnectionFactory createActiveMQConnectionFactory() {
        String brokerUrl = this.determineBrokerUrl();
        if (StringUtils.hasLength((String)this.user) && StringUtils.hasLength((String)this.password)) {
            return new ActiveMQConnectionFactory(this.user, this.password, brokerUrl);
        }
        return new ActiveMQConnectionFactory(brokerUrl);
    }

    String determineBrokerUrl() {
        return ActiveMQProperties.determineBrokerUrl(this.brokerUrl, this.inMemory);
    }

    public static String determineBrokerUrl(Environment environment) {
        RelaxedPropertyResolver resolver = new RelaxedPropertyResolver((PropertyResolver)environment, "spring.activemq.");
        String brokerUrl = resolver.getProperty("brokerUrl");
        Boolean inMemory = (Boolean)resolver.getProperty("inMemory", Boolean.class);
        return ActiveMQProperties.determineBrokerUrl(brokerUrl, inMemory);
    }

    private static String determineBrokerUrl(String brokerUrl, Boolean inMemory) {
        if (brokerUrl != null) {
            return brokerUrl;
        }
        boolean embedded = inMemory == null || inMemory != false;
        return embedded ? DEFAULT_EMBEDDED_BROKER_URL : DEFAULT_NETWORK_BROKER_URL;
    }
}

