/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jdbc;

import javax.annotation.PreDestroy;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.springframework.boot.autoconfigure.jdbc.AbstractDataSourceConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class TomcatDataSourceConfiguration
extends AbstractDataSourceConfiguration {
    private String jdbcInterceptors;
    private long validationInterval = 30000L;
    private DataSource pool;

    @Bean(destroyMethod="close")
    public javax.sql.DataSource dataSource() {
        this.pool = new DataSource();
        this.pool.setDriverClassName(this.getDriverClassName());
        this.pool.setUrl(this.getUrl());
        if (this.getUsername() != null) {
            this.pool.setUsername(this.getUsername());
        }
        if (this.getPassword() != null) {
            this.pool.setPassword(this.getPassword());
        }
        this.pool.setInitialSize(this.getInitialSize());
        this.pool.setMaxActive(this.getMaxActive());
        this.pool.setMaxIdle(this.getMaxIdle());
        this.pool.setMinIdle(this.getMinIdle());
        this.pool.setTestOnBorrow(this.isTestOnBorrow());
        this.pool.setTestOnReturn(this.isTestOnReturn());
        this.pool.setTestWhileIdle(this.isTestWhileIdle());
        if (this.getTimeBetweenEvictionRunsMillis() != null) {
            this.pool.setTimeBetweenEvictionRunsMillis(this.getTimeBetweenEvictionRunsMillis().intValue());
        }
        if (this.getMinEvictableIdleTimeMillis() != null) {
            this.pool.setMinEvictableIdleTimeMillis(this.getMinEvictableIdleTimeMillis().intValue());
        }
        this.pool.setValidationQuery(this.getValidationQuery());
        this.pool.setValidationInterval(this.validationInterval);
        if (this.getMaxWaitMillis() != null) {
            this.pool.setMaxWait(this.getMaxWaitMillis().intValue());
        }
        if (this.jdbcInterceptors != null) {
            this.pool.setJdbcInterceptors(this.jdbcInterceptors);
        }
        return this.pool;
    }

    @PreDestroy
    public void close() {
        if (this.pool != null) {
            this.pool.close();
        }
    }

    public void setJdbcInterceptors(String jdbcInterceptors) {
        this.jdbcInterceptors = jdbcInterceptors;
    }

    public void setValidationInterval(long validationInterval) {
        this.validationInterval = validationInterval;
    }
}

