/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jdbc;

import java.sql.SQLException;
import javax.annotation.PreDestroy;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.jdbc.AbstractDataSourceConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.dao.DataAccessResourceFailureException;

@Configuration
public class CommonsDataSourceConfiguration
extends AbstractDataSourceConfiguration {
    private static Log logger = LogFactory.getLog(CommonsDataSourceConfiguration.class);
    private BasicDataSource pool;

    public CommonsDataSourceConfiguration() {
        this.setInitialSize(0);
    }

    @Bean(destroyMethod="close")
    public DataSource dataSource() {
        logger.info((Object)"Hint: using Commons DBCP BasicDataSource. It's going to work, but the Tomcat DataSource is more reliable.");
        this.pool = this.createAndConfigurePool();
        return this.pool;
    }

    private BasicDataSource createAndConfigurePool() {
        BasicDataSource pool = new BasicDataSource();
        pool.setDriverClassName(this.getDriverClassName());
        pool.setUrl(this.getUrl());
        if (this.getUsername() != null) {
            pool.setUsername(this.getUsername());
        }
        if (this.getPassword() != null) {
            pool.setPassword(this.getPassword());
        }
        pool.setInitialSize(this.getInitialSize());
        pool.setMaxActive(this.getMaxActive());
        pool.setMaxIdle(this.getMaxIdle());
        pool.setMinIdle(this.getMinIdle());
        pool.setTestOnBorrow(this.isTestOnBorrow());
        pool.setTestOnReturn(this.isTestOnReturn());
        pool.setTestWhileIdle(this.isTestWhileIdle());
        pool.setValidationQuery(this.getValidationQuery());
        if (this.getTimeBetweenEvictionRunsMillis() != null) {
            pool.setTimeBetweenEvictionRunsMillis((long)this.getTimeBetweenEvictionRunsMillis().intValue());
        }
        if (this.getMinEvictableIdleTimeMillis() != null) {
            pool.setMinEvictableIdleTimeMillis((long)this.getMinEvictableIdleTimeMillis().intValue());
        }
        if (this.getMaxWaitMillis() != null) {
            pool.setMaxWait((long)this.getMaxWaitMillis().intValue());
        }
        return pool;
    }

    @PreDestroy
    public void close() {
        if (this.pool != null) {
            try {
                this.pool.close();
            }
            catch (SQLException ex) {
                throw new DataAccessResourceFailureException("Could not close data source", (Throwable)ex);
            }
        }
    }
}

