/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.amqp;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="spring.rabbitmq")
public class RabbitProperties {
    private String host = "localhost";
    private int port = 5672;
    private String username;
    private String password;
    private String virtualHost;
    private String addresses;
    private boolean dynamic = true;

    public String getHost() {
        if (this.addresses == null) {
            return this.host;
        }
        String[] hosts = StringUtils.delimitedListToStringArray((String)this.addresses, (String)":");
        if (hosts.length == 2) {
            return hosts[0];
        }
        return null;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        if (this.addresses == null) {
            return this.port;
        }
        String[] hosts = StringUtils.delimitedListToStringArray((String)this.addresses, (String)":");
        if (hosts.length >= 2) {
            return Integer.valueOf(StringUtils.commaDelimitedListToStringArray((String)hosts[1])[0]);
        }
        return this.port;
    }

    public void setAddresses(String addresses) {
        this.addresses = addresses;
    }

    public String getAddresses() {
        return this.addresses == null ? this.host + ":" + this.port : this.addresses;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public void setVirtualHost(String virtualHost) {
        while (virtualHost.startsWith("/") && virtualHost.length() > 0) {
            virtualHost = virtualHost.substring(1);
        }
        this.virtualHost = "/" + virtualHost;
    }
}

