/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.tools;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.springframework.boot.loader.tools.EntryWriter;
import org.springframework.util.StreamUtils;

final class SizeCalculatingEntryWriter
implements EntryWriter {
    static final int THRESHOLD = 20480;
    private final Object content;
    private final int size;

    private SizeCalculatingEntryWriter(EntryWriter entryWriter) throws IOException {
        try (SizeCalculatingOutputStream outputStream = new SizeCalculatingOutputStream();){
            entryWriter.write(outputStream);
        }
        this.content = outputStream.getContent();
        this.size = outputStream.getSize();
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        InputStream inputStream = this.getContentInputStream();
        this.copy(inputStream, outputStream);
    }

    private InputStream getContentInputStream() throws FileNotFoundException {
        if (this.content instanceof File) {
            return new FileInputStream((File)this.content);
        }
        return new ByteArrayInputStream((byte[])this.content);
    }

    private void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        try {
            StreamUtils.copy(inputStream, outputStream);
        }
        finally {
            inputStream.close();
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    static EntryWriter get(EntryWriter entryWriter) throws IOException {
        if (entryWriter == null || entryWriter.size() != -1) {
            return entryWriter;
        }
        return new SizeCalculatingEntryWriter(entryWriter);
    }

    private static class SizeCalculatingOutputStream
    extends OutputStream {
        private int size = 0;
        private File tempFile;
        private OutputStream outputStream = new ByteArrayOutputStream();

        SizeCalculatingOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b}, 0, 1);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            int updatedSize = this.size + len;
            if (updatedSize > 20480 && this.outputStream instanceof ByteArrayOutputStream) {
                this.outputStream = this.convertToFileOutputStream((ByteArrayOutputStream)this.outputStream);
            }
            this.outputStream.write(b, off, len);
            this.size = updatedSize;
        }

        private OutputStream convertToFileOutputStream(ByteArrayOutputStream byteArrayOutputStream) throws IOException {
            this.initializeTempFile();
            FileOutputStream fileOutputStream = new FileOutputStream(this.tempFile);
            StreamUtils.copy(byteArrayOutputStream.toByteArray(), (OutputStream)fileOutputStream);
            return fileOutputStream;
        }

        private void initializeTempFile() throws IOException {
            if (this.tempFile == null) {
                this.tempFile = File.createTempFile("springboot-", "-entrycontent");
                this.tempFile.deleteOnExit();
            }
        }

        @Override
        public void close() throws IOException {
            this.outputStream.close();
        }

        Object getContent() {
            return this.outputStream instanceof ByteArrayOutputStream ? (Object)((ByteArrayOutputStream)this.outputStream).toByteArray() : this.tempFile;
        }

        int getSize() {
            return this.size;
        }
    }
}

