/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.eclipse.aether.util.graph.visitor;

import hidden.org.eclipse.aether.artifact.Artifact;
import hidden.org.eclipse.aether.graph.Dependency;
import hidden.org.eclipse.aether.graph.DependencyNode;
import hidden.org.eclipse.aether.graph.DependencyVisitor;
import java.io.File;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

abstract class AbstractDepthFirstNodeListGenerator
implements DependencyVisitor {
    private final Map<DependencyNode, Object> visitedNodes;
    protected final List<DependencyNode> nodes = new ArrayList<DependencyNode>(128);

    public AbstractDepthFirstNodeListGenerator() {
        this.visitedNodes = new IdentityHashMap<DependencyNode, Object>(512);
    }

    public List<DependencyNode> getNodes() {
        return this.nodes;
    }

    public List<Dependency> getDependencies(boolean includeUnresolved) {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>(this.getNodes().size());
        for (DependencyNode node : this.getNodes()) {
            Dependency dependency = node.getDependency();
            if (dependency == null || !includeUnresolved && dependency.getArtifact().getFile() == null) continue;
            dependencies.add(dependency);
        }
        return dependencies;
    }

    public List<Artifact> getArtifacts(boolean includeUnresolved) {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>(this.getNodes().size());
        for (DependencyNode node : this.getNodes()) {
            if (node.getDependency() == null) continue;
            Artifact artifact = node.getDependency().getArtifact();
            if (!includeUnresolved && artifact.getFile() == null) continue;
            artifacts.add(artifact);
        }
        return artifacts;
    }

    public List<File> getFiles() {
        ArrayList<File> files = new ArrayList<File>(this.getNodes().size());
        for (DependencyNode node : this.getNodes()) {
            File file;
            if (node.getDependency() == null || (file = node.getDependency().getArtifact().getFile()) == null) continue;
            files.add(file);
        }
        return files;
    }

    public String getClassPath() {
        StringBuilder buffer = new StringBuilder(1024);
        Iterator<DependencyNode> it = this.getNodes().iterator();
        while (it.hasNext()) {
            Artifact artifact;
            DependencyNode node = it.next();
            if (node.getDependency() == null || (artifact = node.getDependency().getArtifact()).getFile() == null) continue;
            buffer.append(artifact.getFile().getAbsolutePath());
            if (!it.hasNext()) continue;
            buffer.append(File.pathSeparatorChar);
        }
        return buffer.toString();
    }

    protected boolean setVisited(DependencyNode node) {
        return this.visitedNodes.put(node, Boolean.TRUE) == null;
    }

    @Override
    public abstract boolean visitEnter(DependencyNode var1);

    @Override
    public abstract boolean visitLeave(DependencyNode var1);
}

