/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.maven.repository;

import hidden.org.apache.maven.artifact.ArtifactUtils;
import hidden.org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import hidden.org.apache.maven.model.Dependency;
import java.io.File;

public class VersionNotFoundException
extends Exception {
    private Dependency dependency;
    private String projectId;
    private File pomFile;
    private InvalidVersionSpecificationException cause;

    public VersionNotFoundException(String projectId, Dependency dependency, File pomFile, InvalidVersionSpecificationException cause) {
        super(projectId + ", " + VersionNotFoundException.formatLocationInPom(dependency) + " " + dependency.getVersion() + ", pom file " + pomFile, cause);
        this.projectId = projectId;
        this.pomFile = pomFile;
        this.cause = cause;
        this.dependency = dependency;
    }

    private static String formatLocationInPom(Dependency dependency) {
        return "Dependency: " + ArtifactUtils.versionlessKey(dependency.getGroupId(), dependency.getArtifactId());
    }

    public Dependency getDependency() {
        return this.dependency;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public File getPomFile() {
        return this.pomFile;
    }

    public InvalidVersionSpecificationException getCauseException() {
        return this.cause;
    }
}

