/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.maven.cli.internal;

import hidden.org.apache.maven.RepositoryUtils;
import hidden.org.apache.maven.cli.internal.extension.model.CoreExtension;
import hidden.org.apache.maven.execution.MavenExecutionRequest;
import hidden.org.apache.maven.extension.internal.CoreExtensionEntry;
import hidden.org.apache.maven.internal.aether.DefaultRepositorySystemSessionFactory;
import hidden.org.apache.maven.model.Plugin;
import hidden.org.apache.maven.plugin.PluginResolutionException;
import hidden.org.apache.maven.plugin.internal.DefaultPluginDependenciesResolver;
import hidden.org.eclipse.aether.DefaultRepositorySystemSession;
import hidden.org.eclipse.aether.RepositorySystemSession;
import hidden.org.eclipse.aether.artifact.Artifact;
import hidden.org.eclipse.aether.graph.DependencyFilter;
import hidden.org.eclipse.aether.graph.DependencyNode;
import hidden.org.eclipse.aether.repository.RemoteRepository;
import hidden.org.eclipse.aether.util.filter.ExclusionsDependencyFilter;
import hidden.org.eclipse.aether.util.graph.visitor.PreorderNodeListGenerator;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.logging.Logger;

@Named
public class BootstrapCoreExtensionManager {
    private final Logger log;
    private final DefaultPluginDependenciesResolver pluginDependenciesResolver;
    private final DefaultRepositorySystemSessionFactory repositorySystemSessionFactory;
    private final ClassWorld classWorld;
    private final ClassRealm parentRealm;

    @Inject
    public BootstrapCoreExtensionManager(Logger log, DefaultPluginDependenciesResolver pluginDependenciesResolver, DefaultRepositorySystemSessionFactory repositorySystemSessionFactory, PlexusContainer container) {
        this.log = log;
        this.pluginDependenciesResolver = pluginDependenciesResolver;
        this.repositorySystemSessionFactory = repositorySystemSessionFactory;
        this.classWorld = ((DefaultPlexusContainer)container).getClassWorld();
        this.parentRealm = container.getContainerRealm();
    }

    public List<CoreExtensionEntry> loadCoreExtensions(MavenExecutionRequest request, Set<String> providedArtifacts, List<CoreExtension> extensions) throws Exception {
        DefaultRepositorySystemSession repoSession = this.repositorySystemSessionFactory.newRepositorySession(request);
        List<RemoteRepository> repositories = RepositoryUtils.toRepos(request.getPluginArtifactRepositories());
        return this.resolveCoreExtensions(repoSession, repositories, providedArtifacts, extensions);
    }

    private List<CoreExtensionEntry> resolveCoreExtensions(RepositorySystemSession repoSession, List<RemoteRepository> repositories, Set<String> providedArtifacts, List<CoreExtension> configuration) throws Exception {
        ArrayList<CoreExtensionEntry> extensions = new ArrayList<CoreExtensionEntry>();
        ExclusionsDependencyFilter dependencyFilter = new ExclusionsDependencyFilter(providedArtifacts);
        for (CoreExtension extension : configuration) {
            List<Artifact> artifacts = this.resolveExtension(extension, repoSession, repositories, dependencyFilter);
            if (artifacts.isEmpty()) continue;
            extensions.add(this.createExtension(extension, artifacts));
        }
        return Collections.unmodifiableList(extensions);
    }

    private CoreExtensionEntry createExtension(CoreExtension extension, List<Artifact> artifacts) throws Exception {
        String realmId = "coreExtension>" + extension.getGroupId() + ":" + extension.getArtifactId() + ":" + extension.getVersion();
        ClassRealm realm = this.classWorld.newRealm(realmId, null);
        this.log.debug("Populating class realm " + realm.getId());
        realm.setParentRealm(this.parentRealm);
        for (Artifact artifact : artifacts) {
            File file = artifact.getFile();
            this.log.debug("  Included " + file);
            realm.addURL(file.toURI().toURL());
        }
        return CoreExtensionEntry.discoverFrom(realm, Collections.singleton(artifacts.get(0).getFile()));
    }

    private List<Artifact> resolveExtension(CoreExtension extension, RepositorySystemSession repoSession, List<RemoteRepository> repositories, DependencyFilter dependencyFilter) throws PluginResolutionException {
        Plugin plugin = new Plugin();
        plugin.setGroupId(extension.getGroupId());
        plugin.setArtifactId(extension.getArtifactId());
        plugin.setVersion(extension.getVersion());
        DependencyNode root = this.pluginDependenciesResolver.resolveCoreExtension(plugin, dependencyFilter, repositories, repoSession);
        PreorderNodeListGenerator nlg = new PreorderNodeListGenerator();
        root.accept(nlg);
        List artifacts = nlg.getArtifacts(false);
        return artifacts;
    }
}

