/*
 * Decompiled with CFR 0.152.
 */
package hidden.com.google.inject.spi;

import hidden.com.google.common.base.Preconditions;
import hidden.com.google.common.collect.ImmutableSet;
import hidden.com.google.inject.Binder;
import hidden.com.google.inject.Key;
import hidden.com.google.inject.Provider;
import hidden.com.google.inject.spi.Dependency;
import hidden.com.google.inject.spi.Element;
import hidden.com.google.inject.spi.ElementVisitor;
import hidden.com.google.inject.spi.ProviderWithDependencies;
import hidden.com.google.inject.util.Types;
import java.util.Set;

public final class ProviderLookup<T>
implements Element {
    private final Object source;
    private final Dependency<T> dependency;
    private Provider<T> delegate;

    public ProviderLookup(Object source, Key<T> key) {
        this(source, Dependency.get(Preconditions.checkNotNull(key, "key")));
    }

    public ProviderLookup(Object source, Dependency<T> dependency) {
        this.source = Preconditions.checkNotNull(source, "source");
        this.dependency = Preconditions.checkNotNull(dependency, "dependency");
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    public Key<T> getKey() {
        return this.dependency.getKey();
    }

    public Dependency<T> getDependency() {
        return this.dependency;
    }

    @Override
    public <T> T acceptVisitor(ElementVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public void initializeDelegate(Provider<T> delegate) {
        Preconditions.checkState(this.delegate == null, "delegate already initialized");
        this.delegate = Preconditions.checkNotNull(delegate, "delegate");
    }

    @Override
    public void applyTo(Binder binder) {
        this.initializeDelegate(binder.withSource(this.getSource()).getProvider(this.dependency));
    }

    public Provider<T> getDelegate() {
        return this.delegate;
    }

    public Provider<T> getProvider() {
        return new ProviderWithDependencies<T>(){

            @Override
            public T get() {
                Preconditions.checkState(ProviderLookup.this.delegate != null, "This Provider cannot be used until the Injector has been created.");
                return ProviderLookup.this.delegate.get();
            }

            @Override
            public Set<Dependency<?>> getDependencies() {
                Key<?> providerKey = ProviderLookup.this.getKey().ofType(Types.providerOf(ProviderLookup.this.getKey().getTypeLiteral().getType()));
                return ImmutableSet.of(Dependency.get(providerKey));
            }

            public String toString() {
                String string = String.valueOf(String.valueOf(ProviderLookup.this.getKey().getTypeLiteral()));
                return new StringBuilder(10 + string.length()).append("Provider<").append(string).append(">").toString();
            }
        };
    }
}

