/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.thin;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.jar.Manifest;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.springframework.boot.loader.archive.Archive;
import org.springframework.boot.loader.archive.ExplodedArchive;
import org.springframework.boot.loader.archive.JarFileArchive;
import org.springframework.boot.loader.jar.JarFile;
import org.springframework.boot.loader.thin.DependencyResolver;
import org.springframework.boot.loader.tools.MainClassFinder;
import org.springframework.core.io.UrlResource;

public class ArchiveUtils {
    public static Archive getArchive(Class<?> cls) {
        URL location = cls.getProtectionDomain().getCodeSource().getLocation();
        return ArchiveUtils.getArchive(location.toString());
    }

    public static Archive getArchive(String path) {
        File file = new File(ArchiveUtils.findArchive(path));
        if (file.isDirectory()) {
            return new ExplodedArchive(file);
        }
        try {
            return new JarFileArchive(new JarFile(file));
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot create JAR archive: " + file, e);
        }
    }

    public static File getArchiveRoot(Archive archive) {
        try {
            return new File(ArchiveUtils.jarFile(archive.getUrl()).toURI());
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot locate JAR archive: " + archive, e);
        }
    }

    public static String findMainClass(Archive archive) {
        String mainClass = null;
        try {
            Manifest manifest = archive.getManifest();
            if (manifest != null) {
                mainClass = manifest.getMainAttributes().getValue("Start-Class");
                if (mainClass != null) {
                    return mainClass;
                }
                mainClass = manifest.getMainAttributes().getValue("Main-Class");
                if (mainClass != null) {
                    return mainClass;
                }
            }
        }
        catch (Exception manifest) {
            // empty catch block
        }
        try {
            File root = ArchiveUtils.getArchiveRoot(archive);
            if (archive instanceof ExplodedArchive) {
                return MainClassFinder.findSingleMainClass((File)root);
            }
            return MainClassFinder.findSingleMainClass((java.util.jar.JarFile)new JarFile(root), (String)"");
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot locate main class in " + archive, e);
        }
    }

    private static URI findArchive(String path) {
        URI archive = ArchiveUtils.findPath(path);
        if (archive != null) {
            try {
                return ArchiveUtils.jarFile(archive.toURL()).toURI();
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot create URI for " + archive);
            }
        }
        File dir = new File("target/classes");
        if (dir.exists()) {
            return dir.toURI();
        }
        dir = new File("build/classes");
        if (dir.exists()) {
            return dir.toURI();
        }
        dir = new File(".");
        return dir.toURI();
    }

    private static URI findPath(String path) {
        if (path == null) {
            return null;
        }
        if (path.startsWith("maven:")) {
            String coordinates = path.replaceFirst("maven:\\/*", "");
            DependencyResolver engine = DependencyResolver.instance();
            File resolved = engine.resolve(new Dependency((Artifact)new DefaultArtifact(coordinates), "runtime"));
            return resolved.toURI();
        }
        if (path.startsWith("file:")) {
            path = path.substring("file:".length());
        }
        return new File(path).toURI();
    }

    private static URL jarFile(URL url) {
        String path = url.toString();
        if (path.endsWith("!/")) {
            if ((path = path.substring(0, path.length() - "!/".length())).startsWith("jar:")) {
                path = path.substring("jar:".length());
            }
            try {
                url = new URL(path);
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException("Bad URL for jar file: " + path, e);
            }
        }
        return url;
    }

    public static List<URL> nestedClasses(Archive archive, String ... paths) {
        ArrayList<URL> extras = new ArrayList<URL>();
        try {
            for (String path : paths) {
                UrlResource classes = new UrlResource(archive.getUrl().toString() + path);
                if (!classes.exists()) continue;
                extras.add(classes.getURL());
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot create urls for resources", e);
        }
        return extras;
    }

    public static URL[] addNestedClasses(Archive archive, URL[] urls, String ... paths) {
        List<URL> extras = ArchiveUtils.nestedClasses(archive, paths);
        URL[] result = urls;
        if (!extras.isEmpty()) {
            extras.addAll(Arrays.asList(urls));
            result = extras.toArray(new URL[0]);
        }
        return ArchiveUtils.locateFiles(result);
    }

    private static URL[] locateFiles(URL[] urls) {
        for (int i = 0; i < urls.length; ++i) {
            urls[i] = ArchiveUtils.jarFile(urls[i]);
        }
        return urls;
    }
}

