/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.experimental.gradle;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.Exec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.internal.jvm.Jvm;
import org.gradle.jvm.tasks.Jar;
import org.springframework.boot.experimental.gradle.PomTask;
import org.springframework.boot.experimental.gradle.PropertiesTask;
import org.springframework.util.StringUtils;

public class ThinLauncherPlugin
implements Plugin<Project> {
    public void apply(final Project project) {
        project.getTasks().withType(Jar.class, (Action)new Action<Jar>(){

            public void execute(Jar jar) {
                ThinLauncherPlugin.this.createCopyTask(project, jar);
                ThinLauncherPlugin.this.createResolveTask(project, jar);
                ThinLauncherPlugin.this.createPropertiesTask(project);
                ThinLauncherPlugin.this.createPomTask(project);
            }
        });
    }

    private void createPomTask(final Project project) {
        TaskContainer taskContainer = project.getTasks();
        this.create(taskContainer, "thinPom", PomTask.class, new Action<PomTask>(){

            public void execute(final PomTask thin) {
                thin.doFirst((Action)new Action<Task>(){

                    public void execute(Task task) {
                        SourceSetContainer sourceSets = ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets();
                        File resourcesDir = ((SourceSet)sourceSets.getByName("main")).getOutput().getResourcesDir();
                        thin.setOutput(new File(resourcesDir, "META-INF/maven/" + project.getGroup() + "/" + project.getName()));
                    }
                });
                project.getTasks().withType(Jar.class, (Action)new Action<Jar>(){

                    public void execute(Jar jar) {
                        jar.dependsOn(new Object[]{thin});
                    }
                });
            }
        });
    }

    private void createPropertiesTask(final Project project) {
        TaskContainer taskContainer = project.getTasks();
        this.create(taskContainer, "thinProperties", PropertiesTask.class, new Action<PropertiesTask>(){

            public void execute(PropertiesTask libPropertiesTask) {
                ThinLauncherPlugin.this.configureLibPropertiesTask(libPropertiesTask, project);
            }
        });
    }

    private void configureLibPropertiesTask(PropertiesTask thin, Project project) {
        thin.setConfiguration(this.findRuntimeClasspath(project));
        SourceSetContainer sourceSets = ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets();
        File resourcesDir = ((SourceSet)sourceSets.getByName("main")).getOutput().getResourcesDir();
        thin.setOutput(new File(resourcesDir, "META-INF"));
    }

    private Configuration findRuntimeClasspath(Project project) {
        Configuration configuration = project.getConfigurations().getByName("runtimeClasspath");
        if (configuration == null) {
            configuration = project.getConfigurations().getByName("runtime");
        }
        return configuration;
    }

    private void createCopyTask(final Project project, Jar jar) {
        String task = "bootRepackage";
        Jar thinJar = jar;
        if (project.getTasksByName(task, true).isEmpty()) {
            task = "thinJar" + this.suffix(jar);
            if (this.suffix(jar).startsWith("ThinJar")) {
                return;
            }
            if (!project.getTasksByName(task, true).isEmpty()) {
                return;
            }
            if (this.suffix(jar).isEmpty()) {
                thinJar = this.create(project.getTasks(), task, Jar.class, new Action<Jar>(){

                    public void execute(final Jar thin) {
                        final Jar bootJar = project.getTasks().findByName("bootJar") != null ? (Jar)project.getTasks().getByName("bootJar") : (Jar)project.getTasks().getByName("jar");
                        thin.dependsOn(new Object[]{bootJar});
                        project.getTasks().getByName("assemble").dependsOn(new Object[]{thin});
                        thin.doFirst((Action)new Action<Task>(){

                            public void execute(Task t) {
                                HashMap<String, Object> attrs = new HashMap<String, Object>();
                                attrs.put("Main-Class", "org.springframework.boot.loader.wrapper.ThinJarWrapper");
                                attrs.put("Start-Class", this.getMainClass(bootJar));
                                thin.setManifest(bootJar.getManifest());
                                thin.getManifest().attributes(attrs);
                                SourceSetContainer sources = (SourceSetContainer)project.getProperties().get("sourceSets");
                                thin.from(new Object[]{project.zipTree((Object)new Callable<File>(){

                                    @Override
                                    public File call() throws Exception {
                                        File file = File.createTempFile("tmp", ".jar", project.getBuildDir());
                                        file.delete();
                                        Files.copy(this.getClass().getClassLoader().getResourceAsStream("META-INF/loader/spring-boot-thin-wrapper.jar"), file.toPath(), new CopyOption[0]);
                                        return file;
                                    }
                                })});
                                thin.from(new Object[]{((SourceSet)sources.findByName("main")).getRuntimeClasspath().filter((Spec)new Spec<File>(){

                                    public boolean isSatisfiedBy(File element) {
                                        return element.isDirectory();
                                    }
                                }).getFiles().toArray(new File[0])});
                            }

                            private Object getMainClass(Jar bootJar2) {
                                Object result = bootJar2.getManifest().getAttributes().get((Object)"Start-Class");
                                if (result != null) {
                                    return result;
                                }
                                return bootJar2.getManifest().getAttributes().get((Object)"Main-Class");
                            }
                        });
                        thin.setDescription("Assembles a thin executable jar archive containing the main classes and the thin wrapper.");
                        thin.setGroup("build");
                    }
                });
            }
        }
        final String bootJarTask = task;
        final Jar targetJar = thinJar;
        this.create(project.getTasks(), "thinResolvePrepare" + this.suffix(jar), Copy.class, new Action<Copy>(){

            public void execute(Copy copy) {
                copy.dependsOn(new Object[]{bootJarTask});
                copy.from(new Object[]{targetJar.getOutputs().getFiles()});
                copy.into((Object)new File(project.getBuildDir(), "thin/root"));
                try {
                    File wrapper = new File(project.getBuildDir(), "thin/spring-boot-thin-wrapper.jar");
                    if (!wrapper.exists()) {
                        wrapper.getParentFile().mkdirs();
                        Files.copy(this.getClass().getClassLoader().getResourceAsStream("META-INF/loader/spring-boot-thin-wrapper.jar"), wrapper.toPath(), new CopyOption[0]);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Cannot copy thin jar wrapper", e);
                }
            }
        });
    }

    private void createResolveTask(final Project project, final Jar jar) {
        this.create(project.getTasks(), "thinResolve" + this.suffix(jar), Exec.class, new Action<Exec>(){

            public void execute(final Exec exec) {
                final Jar thinJar = project.getTasks().findByName("thinJar" + ThinLauncherPlugin.this.suffix(jar)) != null ? (Jar)project.getTasks().getByName("thinJar" + ThinLauncherPlugin.this.suffix(jar)) : (Jar)project.getTasks().getByName("jar");
                final String prepareTask = "thinResolvePrepare" + ThinLauncherPlugin.this.suffix(jar);
                exec.dependsOn(new Object[]{prepareTask});
                exec.doFirst((Action)new Action<Task>(){

                    public void execute(Task task) {
                        Copy copy = (Copy)project.getTasks().getByName(prepareTask);
                        exec.setWorkingDir((Object)copy.getOutputs().getFiles().getSingleFile());
                        exec.setCommandLine(new Object[]{Jvm.current().getJavaExecutable()});
                        ArrayList<String> args = new ArrayList<String>(Arrays.asList("-Dthin.root=.", "-Dthin.dryrun", "-jar", "../spring-boot-thin-wrapper.jar"));
                        args.add(1, "-Dthin.archive=" + thinJar.getArchiveName());
                        String thinRepo = ThinLauncherPlugin.this.getThinRepo(project);
                        if (thinRepo != null) {
                            args.add(1, "-Dthin.repo=" + thinRepo);
                        }
                        exec.args(args);
                    }
                });
            }
        });
    }

    private String getThinRepo(Project project) {
        if (System.getProperty("thin.repo") != null) {
            return System.getProperty("thin.repo");
        }
        if (System.getenv("THIN_REPO") != null) {
            return System.getProperty("THIN_REPO");
        }
        Map properties = project.getProperties();
        if (properties != null && properties.get("thin.repo") != null) {
            return (String)properties.get("thin.repo");
        }
        return null;
    }

    private String suffix(Jar jar) {
        String name = jar.getName();
        return "jar".equals(name) || "bootJar".equals(name) ? "" : StringUtils.capitalize((String)name);
    }

    private <T extends Task> T create(TaskContainer taskContainer, String name, Class<T> type, Action<? super T> configuration) throws InvalidUserDataException {
        Task existing = (Task)taskContainer.findByName(name);
        if (existing != null) {
            return (T)existing;
        }
        return (T)taskContainer.create(name, type, configuration);
    }
}

