/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.test.context;

import org.springframework.batch.core.job.Job;
import org.springframework.batch.core.launch.JobOperator;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.test.JobOperatorTestUtils;
import org.springframework.batch.test.JobRepositoryTestUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class BatchTestContextBeanPostProcessor
implements BeanPostProcessor {
    private ObjectProvider<Job> jobProvider;
    private ObjectProvider<JobRepository> jobRepositoryProvider;
    private ObjectProvider<JobOperator> jobOperatorProvider;

    @Autowired
    public void setJobProvider(ObjectProvider<Job> jobProvider) {
        this.jobProvider = jobProvider;
    }

    @Autowired
    public void setJobRepositoryProvider(ObjectProvider<JobRepository> jobRepositoryProvider) {
        this.jobRepositoryProvider = jobRepositoryProvider;
    }

    @Autowired
    public void setJobOperatorProvider(ObjectProvider<JobOperator> jobOperatorProvider) {
        this.jobOperatorProvider = jobOperatorProvider;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof JobOperatorTestUtils) {
            JobOperatorTestUtils jobOperatorTestUtils = (JobOperatorTestUtils)bean;
            this.jobProvider.ifUnique(jobOperatorTestUtils::setJob);
            this.jobRepositoryProvider.ifUnique(jobOperatorTestUtils::setJobRepository);
            this.jobOperatorProvider.ifUnique(jobOperatorTestUtils::setJobOperator);
        }
        if (bean instanceof JobRepositoryTestUtils) {
            JobRepositoryTestUtils jobRepositoryTestUtils = (JobRepositoryTestUtils)bean;
            this.jobRepositoryProvider.ifUnique(jobRepositoryTestUtils::setJobRepository);
        }
        return bean;
    }
}

