/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.test;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class DataSourceInitializer
implements InitializingBean,
DisposableBean {
    private static final Log logger = LogFactory.getLog(DataSourceInitializer.class);
    private Resource[] initScripts;
    private Resource[] destroyScripts;
    private DataSource dataSource;
    private boolean ignoreFailedDrop = true;
    private boolean initialized = false;

    public static void main(String ... args) {
        new ClassPathXmlApplicationContext(ClassUtils.addResourcePathToPackagePath(DataSourceInitializer.class, (String)(DataSourceInitializer.class.getSimpleName() + "-context.xml")));
    }

    public void destroy() {
        if (this.destroyScripts == null) {
            return;
        }
        for (int i = 0; i < this.destroyScripts.length; ++i) {
            Resource destroyScript = this.destroyScripts[i];
            try {
                this.doExecuteScript(destroyScript);
                continue;
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.warn((Object)("Could not execute destroy script [" + destroyScript + "]"), (Throwable)e);
                    continue;
                }
                logger.warn((Object)("Could not execute destroy script [" + destroyScript + "]"));
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.dataSource, (String)"A DataSource is required");
        this.initialize();
    }

    private void initialize() {
        if (!this.initialized) {
            this.destroy();
            if (this.initScripts != null) {
                for (int i = 0; i < this.initScripts.length; ++i) {
                    Resource initScript = this.initScripts[i];
                    this.doExecuteScript(initScript);
                }
            }
            this.initialized = true;
        }
    }

    private void doExecuteScript(final Resource scriptResource) {
        if (scriptResource == null || !scriptResource.exists()) {
            return;
        }
        TransactionTemplate transactionTemplate = new TransactionTemplate((PlatformTransactionManager)new DataSourceTransactionManager(this.dataSource));
        transactionTemplate.execute((TransactionCallback)new TransactionCallback<Void>(){

            public Void doInTransaction(TransactionStatus status) {
                String[] scripts;
                JdbcTemplate jdbcTemplate = new JdbcTemplate(DataSourceInitializer.this.dataSource);
                try {
                    scripts = StringUtils.delimitedListToStringArray((String)DataSourceInitializer.this.stripComments(DataSourceInitializer.this.getScriptLines(scriptResource)), (String)";");
                }
                catch (IOException e) {
                    throw new BeanInitializationException("Cannot load script from [" + scriptResource + "]", (Throwable)e);
                }
                for (int i = 0; i < scripts.length; ++i) {
                    String script = scripts[i].trim();
                    if (!StringUtils.hasText((String)script)) continue;
                    try {
                        jdbcTemplate.execute(script);
                        continue;
                    }
                    catch (DataAccessException e) {
                        if (DataSourceInitializer.this.ignoreFailedDrop && script.toLowerCase().startsWith("drop")) {
                            logger.debug((Object)("DROP script failed (ignoring): " + script));
                            continue;
                        }
                        throw e;
                    }
                }
                return null;
            }
        });
    }

    private List<String> getScriptLines(Resource scriptResource) throws IOException {
        URI uri = scriptResource.getURI();
        this.initFileSystem(uri);
        return Files.readAllLines(Paths.get(uri), StandardCharsets.UTF_8);
    }

    private void initFileSystem(URI uri) throws IOException {
        try {
            FileSystems.getFileSystem(uri);
        }
        catch (FileSystemNotFoundException e) {
            FileSystems.newFileSystem(uri, Collections.emptyMap());
        }
        catch (IllegalArgumentException e) {
            FileSystems.getDefault();
        }
    }

    private String stripComments(List<String> list) {
        StringBuilder buffer = new StringBuilder();
        for (String line : list) {
            if (line.startsWith("//") || line.startsWith("--")) continue;
            buffer.append(line).append("\n");
        }
        return buffer.toString();
    }

    public void setInitScripts(Resource[] initScripts) {
        this.initScripts = initScripts;
    }

    public void setDestroyScripts(Resource[] destroyScripts) {
        this.destroyScripts = destroyScripts;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setIgnoreFailedDrop(boolean ignoreFailedDrop) {
        this.ignoreFailedDrop = ignoreFailedDrop;
    }
}

