/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.test;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.StepLocator;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.test.StepRunner;
import org.springframework.beans.factory.annotation.Autowired;

public class JobLauncherTestUtils {
    private static final long JOB_PARAMETER_MAXIMUM = 1000000L;
    protected final Log logger = LogFactory.getLog(this.getClass());
    private JobLauncher jobLauncher;
    private Job job;
    private JobRepository jobRepository;
    private StepRunner stepRunner;

    @Autowired
    public void setJob(Job job) {
        this.job = job;
    }

    @Autowired
    public void setJobRepository(JobRepository jobRepository) {
        this.jobRepository = jobRepository;
    }

    public JobRepository getJobRepository() {
        return this.jobRepository;
    }

    public Job getJob() {
        return this.job;
    }

    @Autowired
    public void setJobLauncher(JobLauncher jobLauncher) {
        this.jobLauncher = jobLauncher;
    }

    public JobLauncher getJobLauncher() {
        return this.jobLauncher;
    }

    public JobExecution launchJob() throws Exception {
        return this.launchJob(this.getUniqueJobParameters());
    }

    public JobExecution launchJob(JobParameters jobParameters) throws Exception {
        return this.getJobLauncher().run(this.job, jobParameters);
    }

    public JobParameters getUniqueJobParameters() {
        HashMap<String, JobParameter> parameters = new HashMap<String, JobParameter>();
        parameters.put("random", new JobParameter(Long.valueOf((long)(Math.random() * 1000000.0))));
        return new JobParameters(parameters);
    }

    protected StepRunner getStepRunner() {
        if (this.stepRunner == null) {
            this.stepRunner = new StepRunner(this.getJobLauncher(), this.getJobRepository());
        }
        return this.stepRunner;
    }

    public JobExecution launchStep(String stepName) {
        return this.launchStep(stepName, this.getUniqueJobParameters(), null);
    }

    public JobExecution launchStep(String stepName, ExecutionContext jobExecutionContext) {
        return this.launchStep(stepName, this.getUniqueJobParameters(), jobExecutionContext);
    }

    public JobExecution launchStep(String stepName, JobParameters jobParameters) {
        return this.launchStep(stepName, jobParameters, null);
    }

    public JobExecution launchStep(String stepName, JobParameters jobParameters, ExecutionContext jobExecutionContext) {
        if (!(this.job instanceof StepLocator)) {
            throw new UnsupportedOperationException("Cannot locate step from a Job that is not a StepLocator: job=" + this.job.getName() + " does not implement StepLocator");
        }
        StepLocator locator = (StepLocator)this.job;
        Step step = locator.getStep(stepName);
        if (step == null) {
            step = locator.getStep(this.job.getName() + "." + stepName);
        }
        if (step == null) {
            throw new IllegalStateException("No Step found with name: [" + stepName + "]");
        }
        return this.getStepRunner().launchStep(step, jobParameters, jobExecutionContext);
    }
}

