/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.sample.item.writer;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.commons.lang.SerializationUtils;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.item.ClearFailedException;
import org.springframework.batch.item.FlushFailedException;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.repeat.ExitStatus;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.support.JdbcDaoSupport;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;
import org.springframework.jdbc.support.lob.DefaultLobHandler;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class StagingItemWriter
extends JdbcDaoSupport
implements StepExecutionListener,
ItemWriter {
    public static final String NEW = "N";
    public static final String DONE = "Y";
    public static final Object WORKING = "W";
    private DataFieldMaxValueIncrementer incrementer;
    private StepExecution stepExecution;
    private LobHandler lobHandler = new DefaultLobHandler();

    public void setLobHandler(LobHandler lobHandler) {
        this.lobHandler = lobHandler;
    }

    protected void initDao() throws Exception {
        super.initDao();
        Assert.notNull((Object)this.incrementer, (String)("DataFieldMaxValueIncrementer is required - set the incrementer property in the " + ClassUtils.getShortName((Class)StagingItemWriter.class)));
    }

    public void setIncrementer(DataFieldMaxValueIncrementer incrementer) {
        this.incrementer = incrementer;
    }

    public void write(Object data) {
        final long id = this.incrementer.nextLongValue();
        final long jobId = this.stepExecution.getJobExecution().getJobId();
        final byte[] blob = SerializationUtils.serialize((Serializable)((Serializable)data));
        this.getJdbcTemplate().update("INSERT into BATCH_STAGING (ID, JOB_ID, VALUE, PROCESSED) values (?,?,?,?)", new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                ps.setLong(1, id);
                ps.setLong(2, jobId);
                StagingItemWriter.this.lobHandler.getLobCreator().setBlobAsBytes(ps, 3, blob);
                ps.setString(4, StagingItemWriter.NEW);
            }
        });
    }

    public void clear() throws ClearFailedException {
    }

    public void flush() throws FlushFailedException {
    }

    public ExitStatus afterStep(StepExecution stepExecution) {
        return null;
    }

    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    public ExitStatus onErrorInStep(StepExecution stepExecution, Throwable e) {
        return null;
    }
}

